/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.transport;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.net.SocketAddress;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.server.core.transport.ExtendedByteBuf;
import org.infinispan.server.hotrod.logging.Log;

public class TraceChannelHandler
extends ChannelDuplexHandler {
    private static final Log log = (Log)LogFactory.getLog(TraceChannelHandler.class, Log.class);

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        log.tracef("Channel %s connect", (Object)ctx.channel());
        super.connect(ctx, remoteAddress, localAddress, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        log.tracef("%s disconnect", (Object)ctx.channel());
        super.disconnect(ctx, promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        log.tracef("%s close", (Object)ctx.channel());
        super.close(ctx, promise);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        String msgString = msg instanceof ByteBuf ? ExtendedByteBuf.hexDump((ByteBuf)((ByteBuf)msg)) : Util.toStr((Object)msg);
        log.tracef("%s read: %s", (Object)ctx.channel(), (Object)msgString);
        super.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        String msgString = msg instanceof ByteBuf ? ExtendedByteBuf.hexDump((ByteBuf)((ByteBuf)msg)) : Util.toStr((Object)msg);
        log.tracef("%s write: %s", (Object)ctx.channel(), (Object)msgString);
        super.write(ctx, msg, promise);
    }
}

