/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.test;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.transport.NettyChannelInitializer;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.core.transport.NettyInitializers;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.test.AbstractTestTopologyAwareResponse;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.TestClientListener;
import org.infinispan.server.hotrod.test.TestErrorResponse;
import org.infinispan.server.hotrod.test.TestGetResponse;
import org.infinispan.server.hotrod.test.TestGetWithMetadataResponse;
import org.infinispan.server.hotrod.test.TestGetWithVersionResponse;
import org.infinispan.server.hotrod.test.TestHashDistAware10Response;
import org.infinispan.server.hotrod.test.TestHashDistAware11Response;
import org.infinispan.server.hotrod.test.TestHashDistAware20Response;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.server.hotrod.test.TestTopologyAwareResponse;
import org.infinispan.server.hotrod.transport.TestHandlersChannelInitializer;
import org.infinispan.server.hotrod.transport.TimeoutEnabledChannelInitializer;
import org.infinispan.util.KeyValuePair;
import org.testng.AssertJUnit;

public class HotRodTestingUtil {
    private static final Log log = (Log)LogFactory.getLog(HotRodTestingUtil.class, Log.class);
    private static final UniquePortThreadLocal uptl = new UniquePortThreadLocal();
    static final AtomicInteger uniqueAddr = new AtomicInteger(12411);

    private HotRodTestingUtil() {
    }

    public static String host() {
        return "127.0.0.1";
    }

    public static int serverPort() {
        return (Integer)uptl.get();
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager) {
        return HotRodTestingUtil.startHotRodServer(manager, HotRodTestingUtil.serverPort());
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, String defaultCacheName) {
        return HotRodTestingUtil.startHotRodServer(manager, HotRodTestingUtil.serverPort(), 0, HotRodTestingUtil.host(), HotRodTestingUtil.serverPort(), defaultCacheName);
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, String proxyHost, int proxyPort) {
        return HotRodTestingUtil.startHotRodServer(manager, HotRodTestingUtil.serverPort(), 0, proxyHost, proxyPort, null);
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port) {
        return HotRodTestingUtil.startHotRodServer(manager, port, 0);
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, String proxyHost, int proxyPort) {
        return HotRodTestingUtil.startHotRodServer(manager, port, 0, proxyHost, proxyPort, null);
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, int idleTimeout) {
        return HotRodTestingUtil.startHotRodServer(manager, port, idleTimeout, HotRodTestingUtil.host(), port, null);
    }

    public static HotRodServer startHotRodServerWithoutTransport(String ... definedCaches) {
        return HotRodTestingUtil.startHotRodServerWithoutTransport(new HotRodServerConfigurationBuilder(), definedCaches);
    }

    public static HotRodServer startHotRodServerWithoutTransport(HotRodServerConfigurationBuilder builder, String ... definedCaches) {
        GlobalConfigurationBuilder globalConfiguration = new GlobalConfigurationBuilder();
        Configuration cacheConfiguration = new ConfigurationBuilder().encoding().key().mediaType("application/x-java-object").encoding().value().mediaType("application/x-java-object").build();
        builder.startTransport(false);
        DefaultCacheManager cacheManager = new DefaultCacheManager(globalConfiguration.build());
        for (String cache : definedCaches) {
            cacheManager.defineConfiguration(cache, cacheConfiguration);
        }
        return HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)cacheManager, builder);
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, int idleTimeout, String proxyHost, int proxyPort, String defaultCacheName) {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        builder.proxyHost(proxyHost).proxyPort(proxyPort).idleTimeout(idleTimeout);
        if (defaultCacheName != null) {
            builder.defaultCacheName(defaultCacheName);
        }
        return HotRodTestingUtil.startHotRodServer(manager, port, builder);
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, int idleTimeout, String proxyHost, int proxyPort) {
        return HotRodTestingUtil.startHotRodServer(manager, port, idleTimeout, proxyHost, proxyPort, null);
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, HotRodServerConfigurationBuilder builder) {
        return HotRodTestingUtil.startHotRodServer(manager, HotRodTestingUtil.host(), port, builder);
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, HotRodServerConfigurationBuilder builder) {
        return HotRodTestingUtil.startHotRodServer(manager, HotRodTestingUtil.serverPort(), builder);
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, String host, int port, HotRodServerConfigurationBuilder builder) {
        log.infof("Start server in port %d", (Object)port);
        HotRodServer server = new HotRodServer(){

            public ChannelInitializer<Channel> getInitializer() {
                if (((HotRodServerConfiguration)this.configuration).idleTimeout() > 0) {
                    return new NettyInitializers(new NettyInitializer[]{new NettyChannelInitializer((ProtocolServer)this, this.transport, this.getEncoder(), (ChannelInboundHandler)this.getDecoder()), new TimeoutEnabledChannelInitializer((ProtocolServer)this), new TestHandlersChannelInitializer()});
                }
                return new NettyInitializers(new NettyInitializer[]{new NettyChannelInitializer((ProtocolServer)this, this.transport, this.getEncoder(), (ChannelInboundHandler)this.getDecoder()), new TestHandlersChannelInitializer()});
            }
        };
        String shortTestName = TestResourceTracker.getCurrentTestShortName();
        if (!builder.name().contains(shortTestName)) {
            builder.name(shortTestName + builder.name());
        }
        ((HotRodServerConfigurationBuilder)builder.host(host)).port(port);
        builder.ioThreads(3);
        try {
            server.start((ProtocolServerConfiguration)builder.build(), manager);
            return server;
        }
        catch (Throwable t) {
            server.stop();
            throw t;
        }
    }

    public static HotRodServerConfigurationBuilder getDefaultHotRodConfiguration() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        int port = HotRodTestingUtil.serverPort();
        ((HotRodServerConfigurationBuilder)((HotRodServerConfigurationBuilder)builder.host(HotRodTestingUtil.host())).port(port)).proxyHost(HotRodTestingUtil.host()).proxyPort(port);
        return builder;
    }

    public static List<NetworkInterface> findNetworkInterfaces(boolean loopback) {
        try {
            ArrayList<NetworkInterface> matchingInterfaces = new ArrayList<NetworkInterface>();
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                if (!ni.isUp() || ni.isLoopback() != loopback || !ni.getInetAddresses().hasMoreElements()) continue;
                matchingInterfaces.add(ni);
            }
            return matchingInterfaces;
        }
        catch (SocketException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static byte[] k(Method m, String prefix) {
        byte[] bytes = (prefix + m.getName()).getBytes();
        log.tracef("String %s is converted to %s bytes", (Object)(prefix + m.getName()), (Object)Util.printArray((byte[])bytes, (boolean)true));
        return bytes;
    }

    public static byte[] v(Method m, String prefix) {
        return HotRodTestingUtil.k(m, prefix);
    }

    public static byte[] k(Method m) {
        return HotRodTestingUtil.k(m, "k-");
    }

    public static byte[] v(Method m) {
        return HotRodTestingUtil.v(m, "v-");
    }

    public static boolean assertStatus(TestResponse resp, OperationStatus expected) {
        boolean isSuccess;
        OperationStatus status = resp.getStatus();
        boolean bl = isSuccess = status == expected;
        if (resp instanceof TestErrorResponse) {
            AssertJUnit.assertTrue((String)String.format("Status should have been '%s' but instead was: '%s', and the error message was: %s", expected, status, ((TestErrorResponse)resp).msg), (boolean)isSuccess);
        } else {
            AssertJUnit.assertTrue((String)String.format("Status should have been '%s' but instead was: '%s'", expected, status), (boolean)isSuccess);
        }
        return isSuccess;
    }

    public static boolean assertSuccess(TestGetResponse resp, byte[] expected) {
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        boolean isArrayEquals = Arrays.equals(expected, resp.data.get());
        AssertJUnit.assertTrue((String)("Retrieved data should have contained " + Util.printArray((byte[])expected, (boolean)true) + " (" + new String(expected) + "), but instead we received " + Util.printArray((byte[])resp.data.get(), (boolean)true) + " (" + new String(resp.data.get()) + ")"), (boolean)isArrayEquals);
        return isArrayEquals;
    }

    public static void assertByteArrayEquals(byte[] expected, byte[] actual) {
        boolean isArrayEquals = Arrays.equals(expected, actual);
        AssertJUnit.assertTrue((String)("Retrieved data should have contained " + Util.printArray((byte[])expected, (boolean)true) + " (" + new String(expected) + "), but instead we received " + Util.printArray((byte[])actual, (boolean)true) + " (" + new String(actual) + ")"), (boolean)isArrayEquals);
    }

    public static boolean assertSuccess(TestGetWithVersionResponse resp, byte[] expected, int expectedVersion) {
        AssertJUnit.assertTrue((resp.getVersion() != expectedVersion ? 1 : 0) != 0);
        return HotRodTestingUtil.assertSuccess(resp, expected);
    }

    public static boolean assertSuccess(TestGetWithMetadataResponse resp, byte[] expected, int expectedLifespan, int expectedMaxIdle) {
        AssertJUnit.assertEquals((int)resp.lifespan, (int)expectedLifespan);
        AssertJUnit.assertEquals((int)resp.maxIdle, (int)expectedMaxIdle);
        return HotRodTestingUtil.assertSuccess(resp, expected);
    }

    public static boolean assertKeyDoesNotExist(TestGetResponse resp) {
        OperationStatus status = resp.getStatus();
        AssertJUnit.assertTrue((String)("Status should have been 'KeyDoesNotExist' but instead was: " + status), (status == OperationStatus.KeyDoesNotExist ? 1 : 0) != 0);
        AssertJUnit.assertEquals(resp.data, Optional.empty());
        return status == OperationStatus.KeyDoesNotExist;
    }

    public static void assertTopologyReceived(AbstractTestTopologyAwareResponse resp, List<HotRodServer> servers, int expectedTopologyId) {
        AssertJUnit.assertEquals((int)resp.topologyId, (int)expectedTopologyId);
        if (resp instanceof TestHashDistAware10Response) {
            TestHashDistAware10Response h10 = (TestHashDistAware10Response)resp;
            AssertJUnit.assertEquals(new HashSet(h10.members), servers.stream().map(HotRodServer::getAddress).collect(Collectors.toSet()));
        } else if (resp instanceof TestHashDistAware11Response) {
            TestHashDistAware11Response h11 = (TestHashDistAware11Response)resp;
            AssertJUnit.assertEquals(new HashSet(h11.members), servers.stream().map(HotRodServer::getAddress).collect(Collectors.toSet()));
        } else if (resp instanceof TestTopologyAwareResponse) {
            TestTopologyAwareResponse t = (TestTopologyAwareResponse)resp;
            AssertJUnit.assertEquals(new HashSet(t.members), servers.stream().map(HotRodServer::getAddress).collect(Collectors.toSet()));
        } else {
            throw new IllegalArgumentException("Unsupported response!");
        }
    }

    public static void assertHashTopology20Received(AbstractTestTopologyAwareResponse topoResp, List<HotRodServer> servers, String cacheName, int expectedTopologyId) {
        TestHashDistAware20Response hashTopologyResp = (TestHashDistAware20Response)topoResp;
        AssertJUnit.assertEquals((int)expectedTopologyId, (int)hashTopologyResp.topologyId);
        AssertJUnit.assertEquals((int)hashTopologyResp.members.size(), (int)servers.size());
        Set serverAddresses = servers.stream().map(HotRodServer::getAddress).collect(Collectors.toSet());
        hashTopologyResp.members.forEach(member -> AssertJUnit.assertTrue((boolean)serverAddresses.contains(member)));
        AssertJUnit.assertEquals((int)hashTopologyResp.hashFunction, (int)3);
        Cache cache = servers.get(0).getCacheManager().getCache(cacheName);
        LocalizedCacheTopology cacheTopology = cache.getAdvancedCache().getDistributionManager().getCacheTopology();
        AssertJUnit.assertEquals((int)cacheTopology.getActualMembers().size(), (int)servers.size());
        ConsistentHash ch = cacheTopology.getCurrentCH();
        int numSegments = ch.getNumSegments();
        int numOwners = cache.getCacheConfiguration().clustering().hash().numOwners();
        AssertJUnit.assertEquals((int)hashTopologyResp.segments.size(), (int)numSegments);
        for (int i = 0; i < numSegments; ++i) {
            List segment = ch.locateOwnersForSegment(i);
            Iterable<ServerAddress> members = hashTopologyResp.segments.get(i);
            AssertJUnit.assertEquals((int)Math.min(numOwners, ch.getMembers().size()), (int)segment.size());
            int count = 0;
            for (ServerAddress member2 : members) {
                ++count;
                AssertJUnit.assertTrue((boolean)serverAddresses.contains(member2));
            }
            AssertJUnit.assertEquals((int)Math.min(numOwners, servers.size()), (int)count);
        }
    }

    public static int getServerTopologyId(EmbeddedCacheManager cm, String cacheName) {
        return cm.getCache(cacheName).getAdvancedCache().getRpcManager().getTopologyId();
    }

    public static void killClient(HotRodClient client) {
        try {
            if (client != null) {
                client.stop().await();
            }
        }
        catch (Throwable t) {
            log.error((Object)"Error stopping client", t);
        }
    }

    public static ConfigurationBuilder hotRodCacheConfiguration() {
        return HotRodTestingUtil.hotRodCacheConfiguration(new ConfigurationBuilder());
    }

    public static ConfigurationBuilder hotRodCacheConfiguration(ConfigurationBuilder builder) {
        return HotRodTestingUtil.hotRodCacheConfiguration(builder, MediaType.APPLICATION_PROTOSTREAM);
    }

    public static ConfigurationBuilder hotRodCacheConfiguration(ConfigurationBuilder cfg, MediaType types) {
        cfg.encoding().key().mediaType(types.toString());
        cfg.encoding().value().mediaType(types.toString());
        return cfg;
    }

    public static ConfigurationBuilder hotRodCacheConfiguration(MediaType types) {
        return HotRodTestingUtil.hotRodCacheConfiguration(new ConfigurationBuilder(), types);
    }

    public static CacheEntry assertHotRodEquals(EmbeddedCacheManager cm, byte[] key, byte[] expectedValue) {
        return HotRodTestingUtil.assertHotRodEquals((Cache<byte[], byte[]>)cm.getCache(), key, expectedValue);
    }

    public static CacheEntry assertHotRodEquals(EmbeddedCacheManager cm, String cacheName, byte[] key, byte[] expectedValue) {
        return HotRodTestingUtil.assertHotRodEquals((Cache<byte[], byte[]>)cm.getCache(cacheName), key, expectedValue);
    }

    public static CacheEntry assertHotRodEquals(EmbeddedCacheManager cm, String key, String expectedValue) {
        return HotRodTestingUtil.assertHotRodEquals((Cache<byte[], byte[]>)cm.getCache(), HotRodTestingUtil.marshall(key), HotRodTestingUtil.marshall(expectedValue));
    }

    public static CacheEntry assertHotRodEquals(EmbeddedCacheManager cm, String cacheName, String key, String expectedValue) {
        return HotRodTestingUtil.assertHotRodEquals((Cache<byte[], byte[]>)cm.getCache(cacheName), HotRodTestingUtil.marshall(key), HotRodTestingUtil.marshall(expectedValue));
    }

    private static CacheEntry assertHotRodEquals(Cache<byte[], byte[]> cache, byte[] key, byte[] expectedValue) {
        AdvancedCache advancedCache = cache.getAdvancedCache().withStorageMediaType();
        CacheEntry entry = advancedCache.getCacheEntry((Object)key);
        if (expectedValue == null) {
            AssertJUnit.assertNull((Object)entry);
        } else {
            byte[] value = (byte[])entry.getValue();
            AssertJUnit.assertEquals((byte[])expectedValue, (byte[])value);
        }
        return entry;
    }

    public static byte[] marshall(Object obj) {
        try {
            return obj == null ? null : HotRodTestingUtil.getMarshaller().objectToByteBuffer(obj, 64);
        }
        catch (IOException | InterruptedException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static <T> T unmarshall(byte[] key) {
        try {
            return (T)HotRodTestingUtil.getMarshaller().objectFromByteBuffer(key);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private static Marshaller getMarshaller() {
        return new ProtoStreamMarshaller();
    }

    public static void withClientListener(HotRodClient client, TestClientListener listener, Optional<KeyValuePair<String, List<byte[]>>> filterFactory, Optional<KeyValuePair<String, List<byte[]>>> converterFactory, Runnable fn) {
        HotRodTestingUtil.withClientListener(client, listener, filterFactory, converterFactory, false, true, fn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withClientListener(HotRodClient client, TestClientListener listener, Optional<KeyValuePair<String, List<byte[]>>> filterFactory, Optional<KeyValuePair<String, List<byte[]>>> converterFactory, boolean includeState, boolean useRawData, Runnable fn) {
        HotRodTestingUtil.assertStatus(client.addClientListener(listener, includeState, filterFactory == null ? Optional.empty() : filterFactory, converterFactory == null ? Optional.empty() : converterFactory, useRawData), OperationStatus.Success);
        try {
            fn.run();
        }
        finally {
            HotRodTestingUtil.assertStatus(client.removeClientListener(listener.getId()), OperationStatus.Success);
        }
    }

    static class UniquePortThreadLocal
    extends ThreadLocal<Integer> {
        UniquePortThreadLocal() {
        }

        @Override
        protected Integer initialValue() {
            int port = uniqueAddr.getAndAdd(110);
            log.debugf("Server port range for test thread %s is: %d-%d", Thread.currentThread().getId(), (long)port, (long)(port + 109));
            return port;
        }
    }
}

