/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;

public abstract class HotRodSingleNodeTest
extends SingleCacheManagerTest {
    protected String cacheName;
    protected HotRodServer hotRodServer;
    protected HotRodClient hotRodClient;
    protected AdvancedCache<byte[], byte[]> advancedCache;
    private String hotRodJmxDomain = ((Object)((Object)this)).getClass().getSimpleName();

    protected EmbeddedCacheManager createCacheManager() {
        EmbeddedCacheManager cacheManager = this.createTestCacheManager();
        Cache cache = cacheManager.getCache(this.cacheName);
        this.advancedCache = cache.getAdvancedCache();
        return cacheManager;
    }

    protected void setup() throws Exception {
        this.cacheName = "defaultcache";
        super.setup();
        this.hotRodServer = this.createStartHotRodServer(this.cacheManager);
        this.hotRodClient = this.connectClient();
    }

    protected void teardown() {
        this.log.debug((Object)"Killing Hot Rod client and server");
        HotRodTestingUtil.killClient(this.hotRodClient);
        ServerTestingUtil.killServer((AbstractProtocolServer)this.hotRodServer);
        super.teardown();
    }

    protected EmbeddedCacheManager createTestCacheManager() {
        return TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)new GlobalConfigurationBuilder().nonClusteredDefault().defaultCacheName(this.cacheName), (ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
    }

    protected HotRodServer createStartHotRodServer(EmbeddedCacheManager cacheManager) {
        return HotRodTestingUtil.startHotRodServer(cacheManager);
    }

    protected HotRodServer server() {
        return this.hotRodServer;
    }

    protected HotRodClient client() {
        return this.hotRodClient;
    }

    protected String jmxDomain() {
        return this.hotRodJmxDomain;
    }

    protected void shutdownClient() {
        HotRodTestingUtil.killClient(this.hotRodClient);
    }

    protected byte protocolVersion() {
        return 21;
    }

    protected HotRodClient connectClient() {
        return this.connectClient(this.protocolVersion());
    }

    protected HotRodClient connectClient(byte protocolVersion) {
        return new HotRodClient("127.0.0.1", this.hotRodServer.getPort(), this.cacheName, 60, protocolVersion);
    }
}

