/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.iteration;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Ticker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.BaseCacheStream;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.time.TimeServiceTicker;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.encoding.DataConversion;
import org.infinispan.filter.CacheFilters;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverterFactory;
import org.infinispan.filter.ParamKeyValueFilterConverterFactory;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.iteration.DefaultIterationState;
import org.infinispan.server.hotrod.iteration.IterableIterationResult;
import org.infinispan.server.hotrod.iteration.IterationFilter;
import org.infinispan.server.hotrod.iteration.IterationManager;
import org.infinispan.server.hotrod.iteration.IterationReaper;
import org.infinispan.server.hotrod.iteration.IterationSegmentsListener;
import org.infinispan.server.hotrod.iteration.IterationState;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.concurrent.WithinThreadExecutor;

public class DefaultIterationManager
implements IterationManager {
    private static final Log log = (Log)LogFactory.getLog(DefaultIterationManager.class, Log.class);
    private final com.github.benmanes.caffeine.cache.Cache<String, DefaultIterationState> iterationStateMap;
    private final Map<String, KeyValueFilterConverterFactory> filterConverterFactoryMap = new ConcurrentHashMap<String, KeyValueFilterConverterFactory>();

    public DefaultIterationManager(TimeService timeService) {
        Caffeine builder = Caffeine.newBuilder();
        builder.expireAfterAccess(5L, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<String, DefaultIterationState>(){

            public void onRemoval(String key, DefaultIterationState value, RemovalCause cause) {
                value.close();
                if (cause.wasEvicted()) {
                    log.removedUnclosedIterator(key);
                }
            }
        }).ticker((Ticker)new TimeServiceTicker(timeService)).executor((Executor)new WithinThreadExecutor());
        this.iterationStateMap = builder.build();
    }

    @Override
    public IterationState start(Cache cache, BitSet segments, String filterConverterFactory, List<byte[]> filterConverterParams, MediaType requestValueType, int batch, boolean metadata) {
        CacheStream filteredStream;
        CacheStream stream;
        String iterationId = Util.threadLocalRandomUUID().toString();
        AdvancedCache advancedCache = cache.getAdvancedCache();
        DataConversion valueDataConversion = advancedCache.getValueDataConversion();
        Function<Object, Object> unmarshaller = p -> valueDataConversion.convert(p, requestValueType, MediaType.APPLICATION_OBJECT);
        MediaType storageMediaType = advancedCache.getValueDataConversion().getStorageMediaType();
        IterationSegmentsListener segmentListener = new IterationSegmentsListener();
        Function<Object, Object> resultTransformer = Function.identity();
        AdvancedCache iterationCache = advancedCache;
        if (filterConverterFactory == null) {
            stream = advancedCache.cacheEntrySet().stream();
            if (segments != null) {
                stream.filterKeySegments(segments.stream().boxed().collect(Collectors.toSet()));
            }
            filteredStream = stream.segmentCompletionListener((BaseCacheStream.SegmentCompletionListener)segmentListener);
        } else {
            KeyValueFilterConverterFactory factory = this.getFactory(filterConverterFactory);
            KeyValuePair<KeyValueFilterConverter, Boolean> filter = this.buildFilter(factory, (byte[][])filterConverterParams.toArray((T[])Util.EMPTY_BYTE_ARRAY_ARRAY), unmarshaller);
            KeyValueFilterConverter customFilter = (KeyValueFilterConverter)filter.getKey();
            MediaType filterMediaType = customFilter.format();
            if (filterMediaType != null && filterMediaType.equals((Object)storageMediaType)) {
                iterationCache = advancedCache.withEncoding(IdentityEncoder.class).withMediaType(filterMediaType.toString(), filterMediaType.toString());
            }
            stream = iterationCache.cacheEntrySet().stream();
            if (segments != null) {
                stream.filterKeySegments(segments.stream().boxed().collect(Collectors.toSet()));
            }
            IterationFilter iterationFilter = new IterationFilter(storageMediaType, requestValueType, Optional.of((KeyValueFilterConverter)filter.getKey()));
            filteredStream = CacheFilters.filterAndConvert((CacheStream)stream.segmentCompletionListener((BaseCacheStream.SegmentCompletionListener)segmentListener), iterationFilter);
            if (filterMediaType != null && !storageMediaType.equals((Object)requestValueType)) {
                resultTransformer = arg_0 -> ((DataConversion)valueDataConversion).fromStorage(arg_0);
            }
        }
        Iterator<CacheEntry<Object, Object>> iterator = filteredStream.iterator();
        DefaultIterationState iterationState = new DefaultIterationState(iterationId, segmentListener, iterator, (CacheStream<CacheEntry<Object, Object>>)stream, batch, metadata, resultTransformer, new IterationReaper(this, iterationId));
        this.iterationStateMap.put((Object)iterationId, (Object)iterationState);
        return iterationState;
    }

    private KeyValueFilterConverterFactory getFactory(String name) {
        KeyValueFilterConverterFactory factory = this.filterConverterFactoryMap.get(name);
        if (factory == null) {
            throw log.missingKeyValueFilterConverterFactory(name);
        }
        return factory;
    }

    private KeyValuePair<KeyValueFilterConverter, Boolean> buildFilter(KeyValueFilterConverterFactory factory, byte[][] params, Function<Object, Object> unmarshallParam) {
        if (factory instanceof ParamKeyValueFilterConverterFactory) {
            ParamKeyValueFilterConverterFactory paramFactory = (ParamKeyValueFilterConverterFactory)factory;
            Object unmarshallParams = paramFactory.binaryParam() ? params : (Object)Arrays.stream(params).map(unmarshallParam).toArray();
            return new KeyValuePair((Object)paramFactory.getFilterConverter((Object[])unmarshallParams), (Object)paramFactory.binaryParam());
        }
        return new KeyValuePair((Object)factory.getFilterConverter(), (Object)false);
    }

    @Override
    public IterableIterationResult next(String iterationId) {
        DefaultIterationState iterationState = (DefaultIterationState)this.iterationStateMap.getIfPresent((Object)iterationId);
        if (iterationState != null) {
            int i = 0;
            ArrayList<CacheEntry> entries = new ArrayList<CacheEntry>(iterationState.batch);
            while (i++ < iterationState.batch && iterationState.iterator.hasNext()) {
                entries.add(iterationState.iterator.next());
            }
            return new IterableIterationResult(iterationState.listener.getFinished(entries.isEmpty()), OperationStatus.Success, entries, iterationState.metadata, iterationState.resultFunction);
        }
        return new IterableIterationResult(Collections.emptySet(), OperationStatus.InvalidIteration, Collections.emptyList(), false, Function.identity());
    }

    @Override
    public IterationState close(String iterationId) {
        DefaultIterationState iterationState = (DefaultIterationState)this.iterationStateMap.getIfPresent((Object)iterationId);
        if (iterationState != null) {
            this.iterationStateMap.invalidate((Object)iterationId);
        }
        return iterationState;
    }

    @Override
    public void addKeyValueFilterConverterFactory(String name, KeyValueFilterConverterFactory factory) {
        this.filterConverterFactoryMap.put(name, factory);
    }

    @Override
    public void removeKeyValueFilterConverterFactory(String name) {
        this.filterConverterFactoryMap.remove(name);
    }

    @Override
    public int activeIterations() {
        this.iterationStateMap.cleanUp();
        return this.iterationStateMap.asMap().size();
    }
}

