/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.command.tx;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.InitializableCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.ByteString;

abstract class AbstractForwardTxCommand
extends BaseRpcCommand
implements InitializableCommand {
    protected XidImpl xid;
    protected long timeout;
    protected AdvancedCache cache;

    AbstractForwardTxCommand(ByteString cacheName) {
        super(cacheName);
    }

    AbstractForwardTxCommand(ByteString cacheName, XidImpl xid, long timeout) {
        super(cacheName);
        this.xid = xid;
        this.timeout = timeout;
    }

    public void init(ComponentRegistry componentRegistry, boolean isRemote) {
        this.cache = (AdvancedCache)componentRegistry.getCache().wired();
    }

    public boolean isReturnValueExpected() {
        return false;
    }

    public boolean canBlock() {
        return true;
    }

    public void writeTo(ObjectOutput output) throws IOException {
        XidImpl.writeTo((ObjectOutput)output, (XidImpl)this.xid);
        output.writeLong(this.timeout);
    }

    public void readFrom(ObjectInput input) throws IOException {
        this.xid = XidImpl.readFrom((ObjectInput)input);
        this.timeout = input.readLong();
    }
}

