/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.event;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodSingleNodeTest;
import org.infinispan.server.hotrod.event.EventLogListener;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.util.KeyValuePair;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.event.HotRodFilterEventsTest")
public class HotRodFilterEventsTest
extends HotRodSingleNodeTest {
    @Override
    protected HotRodServer createStartHotRodServer(EmbeddedCacheManager cacheManager) {
        HotRodServer server = HotRodTestingUtil.startHotRodServer(cacheManager);
        server.addCacheEventFilterFactory("static-filter-factory", (CacheEventFilterFactory)new StaticKeyValueFilterFactory(new byte[]{1, 2, 3}));
        server.addCacheEventFilterFactory("dynamic-filter-factory", (CacheEventFilterFactory)new DynamicKeyValueFilterFactory());
        return server;
    }

    public void testFilteredEvents(Method m) {
        EventLogListener eventListener = new EventLogListener();
        byte[] acceptedKey = new byte[]{1, 2, 3};
        HotRodTestingUtil.withClientListener(this.client(), eventListener, Optional.of(new KeyValuePair((Object)"static-filter-factory", Collections.emptyList())), Optional.empty(), () -> {
            eventListener.expectNoEvents(Optional.empty());
            byte[] key = HotRodTestingUtil.k(m);
            this.client().remove(key);
            eventListener.expectNoEvents(Optional.empty());
            this.client().put(key, 0, 0, HotRodTestingUtil.v(m));
            eventListener.expectNoEvents(Optional.empty());
            this.client().put(acceptedKey, 0, 0, HotRodTestingUtil.v(m));
            eventListener.expectSingleEvent(this.cache, acceptedKey, Event.Type.CACHE_ENTRY_CREATED);
            this.client().put(acceptedKey, 0, 0, HotRodTestingUtil.v(m, "v2-"));
            eventListener.expectSingleEvent(this.cache, acceptedKey, Event.Type.CACHE_ENTRY_MODIFIED);
            this.client().remove(key);
            eventListener.expectNoEvents(Optional.empty());
            this.client().remove(acceptedKey);
            eventListener.expectSingleEvent(this.cache, acceptedKey, Event.Type.CACHE_ENTRY_REMOVED);
        });
    }

    public void testParameterBasedFiltering(Method m) {
        EventLogListener eventListener = new EventLogListener();
        byte[] acceptedKey = new byte[]{4, 5, 6};
        HotRodTestingUtil.withClientListener(this.client(), eventListener, Optional.of(new KeyValuePair((Object)"dynamic-filter-factory", Collections.singletonList(new byte[]{4, 5, 6}))), Optional.empty(), () -> {
            eventListener.expectNoEvents(Optional.empty());
            byte[] key = HotRodTestingUtil.k(m);
            this.client().put(key, 0, 0, HotRodTestingUtil.v(m));
            eventListener.expectNoEvents(Optional.empty());
            this.client().put(acceptedKey, 0, 0, HotRodTestingUtil.v(m));
            eventListener.expectSingleEvent(this.cache, acceptedKey, Event.Type.CACHE_ENTRY_CREATED);
            this.client().put(acceptedKey, 0, 0, HotRodTestingUtil.v(m, "v2-"));
            eventListener.expectSingleEvent(this.cache, acceptedKey, Event.Type.CACHE_ENTRY_MODIFIED);
            this.client().remove(key);
            eventListener.expectNoEvents(Optional.empty());
            this.client().remove(acceptedKey);
            eventListener.expectSingleEvent(this.cache, acceptedKey, Event.Type.CACHE_ENTRY_REMOVED);
        });
    }

    public void testFilteredEventsReplay(Method m) {
        EventLogListener eventListener = new EventLogListener();
        byte[] staticAcceptedKey = new byte[]{1, 2, 3};
        byte[] dynamicAcceptedKey = new byte[]{7, 8, 9};
        byte[] key = HotRodTestingUtil.k(m);
        this.client().put(key, 0, 0, HotRodTestingUtil.v(m));
        this.client().put(staticAcceptedKey, 0, 0, HotRodTestingUtil.v(m));
        this.client().put(dynamicAcceptedKey, 0, 0, HotRodTestingUtil.v(m));
        HotRodTestingUtil.withClientListener(this.client(), eventListener, Optional.of(new KeyValuePair((Object)"static-filter-factory", Collections.emptyList())), Optional.empty(), true, true, () -> eventListener.expectSingleEvent(this.cache, staticAcceptedKey, Event.Type.CACHE_ENTRY_CREATED));
        HotRodTestingUtil.withClientListener(this.client(), eventListener, Optional.of(new KeyValuePair((Object)"dynamic-filter-factory", Collections.singletonList(new byte[]{7, 8, 9}))), Optional.empty(), true, true, () -> eventListener.expectSingleEvent(this.cache, dynamicAcceptedKey, Event.Type.CACHE_ENTRY_CREATED));
    }

    public void testFilteredEventsNoReplay(Method m) {
        EventLogListener eventListener = new EventLogListener();
        byte[] staticAcceptedKey = new byte[]{1, 2, 3};
        byte[] dynamicAcceptedKey = new byte[]{7, 8, 9};
        byte[] key = HotRodTestingUtil.k(m);
        this.client().put(key, 0, 0, HotRodTestingUtil.v(m));
        this.client().put(staticAcceptedKey, 0, 0, HotRodTestingUtil.v(m));
        this.client().put(dynamicAcceptedKey, 0, 0, HotRodTestingUtil.v(m));
        HotRodTestingUtil.withClientListener(this.client(), eventListener, Optional.of(new KeyValuePair((Object)"static-filter-factory", Collections.emptyList())), Optional.empty(), false, true, () -> eventListener.expectNoEvents(Optional.empty()));
        HotRodTestingUtil.withClientListener(this.client(), eventListener, Optional.of(new KeyValuePair((Object)"dynamic-filter-factory", Collections.singletonList(new byte[]{7, 8, 9}))), Optional.empty(), false, true, () -> eventListener.expectNoEvents(Optional.empty()));
    }

    static class DynamicKeyValueFilterFactory
    implements CacheEventFilterFactory {
        DynamicKeyValueFilterFactory() {
        }

        public <K, V> CacheEventFilter<K, V> getFilter(Object[] params) {
            return (key, oldValue, oldMetadata, newValue, newMetadata, eventType) -> {
                byte[] acceptedKey = (byte[])params[0];
                return Arrays.equals((byte[])key, acceptedKey);
            };
        }
    }

    static class StaticKeyValueFilterFactory
    implements CacheEventFilterFactory {
        private byte[] staticKey;

        StaticKeyValueFilterFactory(byte[] staticKey) {
            this.staticKey = staticKey;
        }

        public <K, V> CacheEventFilter<K, V> getFilter(Object[] params) {
            return (key, prevValue, prevMetadata, value, metadata, eventType) -> Arrays.equals((byte[])key, this.staticKey);
        }
    }
}

