/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.interceptors.BaseAsyncInterceptor;

class FlagCheckCommandInterceptor
extends BaseAsyncInterceptor {
    volatile boolean expectSkipLoadFlag = false;

    FlagCheckCommandInterceptor() {
    }

    public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
        if (command instanceof FlagAffectedCommand) {
            FlagAffectedCommand flagAffectedCommand = (FlagAffectedCommand)command;
            if (flagAffectedCommand.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
                return this.invokeNext(ctx, command);
            }
            boolean hasFlag = flagAffectedCommand.hasAnyFlag(FlagBitSets.SKIP_CACHE_LOAD);
            if (this.expectSkipLoadFlag && !hasFlag) {
                throw new CacheException("SKIP_CACHE_LOAD flag is expected!");
            }
            if (!this.expectSkipLoadFlag && hasFlag) {
                throw new CacheException("SKIP_CACHE_LOAD flag is *not* expected!");
            }
        }
        return this.invokeNext(ctx, command);
    }
}

