/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.util.ArrayList;
import org.infinispan.Cache;
import org.infinispan.distribution.TestAddress;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachemanagerlistener.event.Event;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.impl.EventImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.hotrod.CrashedMemberDetectorListener;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.CrashedMemberDetectorTest")
public class CrashedMemberDetectorTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() {
        return TestCacheManagerFactory.createCacheManager();
    }

    public void testDetectCrashedMembers() {
        Cache cache = this.cacheManager.getCache();
        cache.put((Object)new TestAddress(1), (Object)new ServerAddress("a", 123));
        cache.put((Object)new TestAddress(2), (Object)new ServerAddress("b", 456));
        cache.put((Object)new TestAddress(3), (Object)new ServerAddress("c", 789));
        CrashedMemberDetectorListener detector = new CrashedMemberDetectorListener(cache, null);
        ArrayList<TestAddress> oldMembers = new ArrayList<TestAddress>();
        oldMembers.add(new TestAddress(1));
        oldMembers.add(new TestAddress(3));
        oldMembers.add(new TestAddress(2));
        ArrayList<TestAddress> newMembers = new ArrayList<TestAddress>();
        newMembers.add(new TestAddress(1));
        newMembers.add(new TestAddress(2));
        EventImpl e = new EventImpl("", this.cacheManager, Event.Type.VIEW_CHANGED, newMembers, oldMembers, (Address)new TestAddress(1), 99);
        detector.detectCrashedMember((ViewChangedEvent)e);
        AssertJUnit.assertTrue((boolean)cache.containsKey((Object)new TestAddress(1)));
        AssertJUnit.assertTrue((boolean)cache.containsKey((Object)new TestAddress(2)));
    }
}

