/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.logging;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.counter.exception.CounterException;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.server.hotrod.MissingFactoryException;
import org.infinispan.server.hotrod.logging.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String exceptionReported = "ISPN005003: Exception reported";
    private static final String noMembersInHashTopology = "ISPN005019: No members for new topology after applying consistent hash %s filtering into base topology %s";
    private static final String noMembersInTopology = "ISPN005020: No members in new topology";
    private static final String errorDetectingCrashedMember = "ISPN006002: Error detecting crashed member";
    private static final String serverAuthenticationProvider = "ISPN006005: Cannot enable authentication without specifying a ServerAuthenticationProvider";
    private static final String invalidAllowedMechs = "ISPN006006: The specified allowedMechs [%s] contains mechs which are unsupported by the underlying factories [%s]";
    private static final String invalidOperation = "ISPN006007: The requested operation is invalid";
    private static final String missingServerName = "ISPN006008: A serverName must be specified when enabling authentication";
    private static final String unexpectedEvent = "ISPN006009: Event not handled by current Hot Rod event implementation: '%s'";
    private static final String warnConditionalOperationNonTransactional = "ISPN006010: Conditional operation '%s' should be used with transactional caches, otherwise data inconsistency issues could arise under failure situations";
    private static final String warnForceReturnPreviousNonTransactional = "ISPN006011: Operation '%s' forced to return previous value should be used on transactional caches, otherwise data inconsistency issues could arise under failure situations";
    private static final String missingCacheEventFactory = "ISPN006013: Listener %s factory '%s' not found in server";
    private static final String illegalFilterConverterEventFactory = "ISPN006014: Trying to add a filter and converter factory with name '%s' but it does not extend CacheEventFilterConverterFactory";
    private static final String missingKeyValueFilterConverterFactory = "ISPN006016: Factory '%s' not found in server";
    private static final String unauthorizedOperation = "ISPN006017: Unauthorized operation";
    private static final String externalMechNotAllowedWithoutSSLClientCert = "ISPN006018: EXTERNAL SASL mechanism not allowed without SSL client certificate";
    private static final String missingHostAddress = "ISPN006019: A host or proxyHost address has not been specified";
    private static final String expectedTransactionalCache = "ISPN006020: Cache '%s' is not transactional to execute a client transaction";
    private static final String unexpectedIsolationLevel = "ISPN006021: Cache '%s' must have REPEATABLE_READ isolation level";
    private static final String invalidWeakCounter = "ISPN028023: Expects a STRONG counter for '%s'";
    private static final String skippingMarshallerWrapping = "ISPN028024: Not wrapping custom marshaller with media type '%s' since the format is already supported by the server";
    private static final String errorSerializingResponse = "ISPN028025: Error serializing script response '%s'";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void exceptionReported(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.exceptionReported$str(), new Object[0]);
    }

    protected String exceptionReported$str() {
        return exceptionReported;
    }

    @Override
    public final void noMembersInHashTopology(ConsistentHash ch, String topologyMap) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noMembersInHashTopology$str(), (Object)ch, (Object)topologyMap);
    }

    protected String noMembersInHashTopology$str() {
        return noMembersInHashTopology;
    }

    @Override
    public final void noMembersInTopology() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noMembersInTopology$str(), new Object[0]);
    }

    protected String noMembersInTopology$str() {
        return noMembersInTopology;
    }

    @Override
    public final void errorDetectingCrashedMember(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.errorDetectingCrashedMember$str(), new Object[0]);
    }

    protected String errorDetectingCrashedMember$str() {
        return errorDetectingCrashedMember;
    }

    protected String serverAuthenticationProvider$str() {
        return serverAuthenticationProvider;
    }

    @Override
    public final CacheConfigurationException serverAuthenticationProvider() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.serverAuthenticationProvider$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidAllowedMechs$str() {
        return invalidAllowedMechs;
    }

    @Override
    public final CacheConfigurationException invalidAllowedMechs(Set<String> allowedMechs, Set<String> allMechs) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidAllowedMechs$str(), allowedMechs, allMechs));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidOperation$str() {
        return invalidOperation;
    }

    @Override
    public final UnsupportedOperationException invalidOperation() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.invalidOperation$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingServerName$str() {
        return missingServerName;
    }

    @Override
    public final CacheConfigurationException missingServerName() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingServerName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedEvent$str() {
        return unexpectedEvent;
    }

    @Override
    public final IllegalStateException unexpectedEvent(Event e) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unexpectedEvent$str(), e));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void warnConditionalOperationNonTransactional(String op) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnConditionalOperationNonTransactional$str(), (Object)op);
    }

    protected String warnConditionalOperationNonTransactional$str() {
        return warnConditionalOperationNonTransactional;
    }

    @Override
    public final void warnForceReturnPreviousNonTransactional(String op) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnForceReturnPreviousNonTransactional$str(), (Object)op);
    }

    protected String warnForceReturnPreviousNonTransactional$str() {
        return warnForceReturnPreviousNonTransactional;
    }

    protected String missingCacheEventFactory$str() {
        return missingCacheEventFactory;
    }

    @Override
    public final MissingFactoryException missingCacheEventFactory(String factoryType, String name) {
        MissingFactoryException result = new MissingFactoryException(String.format(this.getLoggingLocale(), this.missingCacheEventFactory$str(), factoryType, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalFilterConverterEventFactory$str() {
        return illegalFilterConverterEventFactory;
    }

    @Override
    public final IllegalStateException illegalFilterConverterEventFactory(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.illegalFilterConverterEventFactory$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingKeyValueFilterConverterFactory$str() {
        return missingKeyValueFilterConverterFactory;
    }

    @Override
    public final IllegalStateException missingKeyValueFilterConverterFactory(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.missingKeyValueFilterConverterFactory$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unauthorizedOperation$str() {
        return unauthorizedOperation;
    }

    @Override
    public final SecurityException unauthorizedOperation() {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.unauthorizedOperation$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String externalMechNotAllowedWithoutSSLClientCert$str() {
        return externalMechNotAllowedWithoutSSLClientCert;
    }

    @Override
    public final SecurityException externalMechNotAllowedWithoutSSLClientCert() {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.externalMechNotAllowedWithoutSSLClientCert$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingHostAddress$str() {
        return missingHostAddress;
    }

    @Override
    public final CacheConfigurationException missingHostAddress() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingHostAddress$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String expectedTransactionalCache$str() {
        return expectedTransactionalCache;
    }

    @Override
    public final IllegalStateException expectedTransactionalCache(String cacheName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.expectedTransactionalCache$str(), cacheName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedIsolationLevel$str() {
        return unexpectedIsolationLevel;
    }

    @Override
    public final IllegalStateException unexpectedIsolationLevel(String cacheName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unexpectedIsolationLevel$str(), cacheName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidWeakCounter$str() {
        return invalidWeakCounter;
    }

    @Override
    public final CounterException invalidWeakCounter(String name) {
        CounterException result = new CounterException(String.format(this.getLoggingLocale(), this.invalidWeakCounter$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void skippingMarshallerWrapping(String mediaType) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.skippingMarshallerWrapping$str(), (Object)mediaType);
    }

    protected String skippingMarshallerWrapping$str() {
        return skippingMarshallerWrapping;
    }

    protected String errorSerializingResponse$str() {
        return errorSerializingResponse;
    }

    @Override
    public final EncodingException errorSerializingResponse(Object o) {
        EncodingException result = new EncodingException(String.format(this.getLoggingLocale(), this.errorSerializingResponse$str(), o));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

