/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.channel.Channel;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.server.hotrod.BaseRequestProcessor;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.SecurityActions;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskManager;

public class TaskRequestProcessor
extends BaseRequestProcessor {
    private static final Log log = (Log)LogFactory.getLog(TaskRequestProcessor.class, Log.class);
    private final HotRodServer server;
    private final TaskManager taskManager;

    TaskRequestProcessor(Channel channel, Executor executor, HotRodServer server) {
        super(channel, executor, server);
        this.server = server;
        this.taskManager = (TaskManager)SecurityActions.getGlobalComponentRegistry(server.getCacheManager()).getComponent(TaskManager.class);
    }

    public void exec(HotRodHeader header, Subject subject, String taskName, Map<String, byte[]> taskParams) {
        AdvancedCache<byte[], byte[]> cache = this.server.cache(this.server.getCacheInfo(header), header, subject);
        TaskContext taskContext = new TaskContext().cache(cache).parameters(taskParams).subject(subject);
        this.taskManager.runTask(taskName, taskContext).whenComplete((result, throwable) -> this.handleExec(header, result, (Throwable)throwable));
    }

    private void handleExec(HotRodHeader header, Object result, Throwable throwable) {
        if (throwable != null) {
            this.writeException(header, throwable);
        } else if (result != null && !(result instanceof byte[])) {
            this.writeException(header, (Throwable)log.errorSerializingResponse(result));
        } else {
            this.writeResponse(header, header.encoder().valueResponse(header, this.server, this.channel.alloc(), OperationStatus.Success, result == null ? Util.EMPTY_BYTE_ARRAY : (byte[])result));
        }
    }
}

