/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.remoting.transport.Address;

public class ServerAddress
implements Address {
    private final String host;
    private final int port;

    public ServerAddress(String host, int port) {
        this.host = Objects.requireNonNull(host);
        this.port = port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerAddress that = (ServerAddress)o;
        if (this.port != that.port) {
            return false;
        }
        return this.host.equals(that.host);
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public int compareTo(Address o) {
        if (o instanceof ServerAddress) {
            ServerAddress oa = (ServerAddress)o;
            int cmp = this.host.compareTo(oa.host);
            if (cmp == 0) {
                cmp = this.port - oa.port;
            }
            return cmp;
        }
        return -1;
    }

    public String toString() {
        return "ServerAddress{host='" + this.host + '\'' + ", port=" + this.port + '}';
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    static class Externalizer
    extends AbstractExternalizer<ServerAddress> {
        Externalizer() {
        }

        public Set<Class<? extends ServerAddress>> getTypeClasses() {
            return Collections.singleton(ServerAddress.class);
        }

        public void writeObject(ObjectOutput output, ServerAddress object) throws IOException {
            output.writeObject(object.host);
            output.writeShort(object.port);
        }

        public ServerAddress readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String host = (String)input.readObject();
            int port = input.readUnsignedShort();
            return new ServerAddress(host, port);
        }
    }
}

