/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.test;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.hotrod.test.ClientHandler;
import org.infinispan.server.hotrod.test.Decoder;
import org.infinispan.server.hotrod.test.Encoder;
import org.infinispan.server.hotrod.test.HotRodClient;

class ClientChannelInitializer
implements NettyInitializer {
    private final HotRodClient client;
    private final int rspTimeoutSeconds;
    private final SSLEngine sslEngine;
    private final byte protocolVersion;

    ClientChannelInitializer(HotRodClient client, int rspTimeoutSeconds, SSLEngine sslEngine, byte protocolVersion) {
        this.client = client;
        this.rspTimeoutSeconds = rspTimeoutSeconds;
        this.sslEngine = sslEngine;
        this.protocolVersion = protocolVersion;
    }

    public void initializeChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.sslEngine != null) {
            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(this.sslEngine));
        }
        pipeline.addLast("decoder", (ChannelHandler)new Decoder(this.client));
        pipeline.addLast("encoder", (ChannelHandler)new Encoder(this.protocolVersion));
        pipeline.addLast("handler", (ChannelHandler)new ClientHandler(this.rspTimeoutSeconds));
    }
}

