/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.logging;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.infinispan.commons.test.skip.StringLogAppender;
import org.infinispan.server.hotrod.HotRodSingleNodeTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.logging.HotRodAccessLoggingTest")
public class HotRodAccessLoggingTest
extends HotRodSingleNodeTest {
    public static final String LOG_FORMAT = "%X{address} %X{user} [%d{dd/MMM/yyyy:HH:mm:ss z}] \"%X{method} %m %X{protocol}\" %X{status} %X{requestSize} %X{responseSize} %X{duration}";
    StringLogAppender logAppender;

    @Override
    protected void setup() throws Exception {
        this.logAppender = new StringLogAppender("org.infinispan.HOTROD_ACCESS_LOG", Level.TRACE, t -> t.getName().startsWith("HotRod-HotRodAccessLoggingTest-ServerIO"), (Layout)PatternLayout.newBuilder().withPattern(LOG_FORMAT).build());
        this.logAppender.install();
        super.setup();
    }

    @Override
    protected void teardown() {
        this.logAppender.uninstall();
        super.teardown();
    }

    public void testHotRodAccessLog() {
        this.client().put("key", "value");
        this.server().getTransport().stop();
        String logline = this.logAppender.getLog(0).toString();
        AssertJUnit.assertTrue((String)logline, (boolean)logline.matches("^127\\.0\\.0\\.1 - \\[\\d+/\\w+/\\d+:\\d+:\\d+:\\d+ [+-]?\\w+\\] \"PUT /HotRodCache/\\[B0x6B6579 HOTROD/2\\.1\" OK \\d+ \\d+ \\d+$"));
    }
}

