/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.event;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.server.hotrod.HotRodSingleNodeTest;
import org.infinispan.server.hotrod.event.EventLogListener;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestGetWithVersionResponse;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.event.HotRodEventsTest")
public class HotRodEventsTest
extends HotRodSingleNodeTest {
    public void testCreatedEvent(Method m) {
        EventLogListener eventListener = new EventLogListener();
        HotRodTestingUtil.withClientListener(this.client(), eventListener, Optional.empty(), Optional.empty(), () -> {
            eventListener.expectNoEvents(Optional.empty());
            byte[] key = HotRodTestingUtil.k(m);
            this.client().put(key, 0, 0, HotRodTestingUtil.v(m));
            eventListener.expectOnlyCreatedEvent(this.cache, key);
        });
    }

    public void testModifiedEvent(Method m) {
        EventLogListener eventListener = new EventLogListener();
        HotRodTestingUtil.withClientListener(this.client(), eventListener, Optional.empty(), Optional.empty(), () -> {
            eventListener.expectNoEvents(Optional.empty());
            byte[] key = HotRodTestingUtil.k(m);
            this.client().put(key, 0, 0, HotRodTestingUtil.v(m));
            eventListener.expectOnlyCreatedEvent(this.cache, key);
            this.client().put(key, 0, 0, HotRodTestingUtil.v(m, "v2-"));
            eventListener.expectOnlyModifiedEvent(this.cache, key);
        });
    }

    public void testRemovedEvent(Method m) {
        EventLogListener eventListener = new EventLogListener();
        HotRodTestingUtil.withClientListener(this.client(), eventListener, Optional.empty(), Optional.empty(), () -> {
            eventListener.expectNoEvents(Optional.empty());
            byte[] key = HotRodTestingUtil.k(m);
            this.client().remove(key);
            eventListener.expectNoEvents(Optional.empty());
            this.client().put(key, 0, 0, HotRodTestingUtil.v(m));
            eventListener.expectOnlyCreatedEvent(this.cache, key);
            this.client().remove(key);
            eventListener.expectOnlyRemovedEvent(this.cache, key);
        });
    }

    public void testReplaceEvents(Method m) {
        EventLogListener eventListener = new EventLogListener();
        HotRodTestingUtil.withClientListener(this.client(), eventListener, Optional.empty(), Optional.empty(), () -> {
            eventListener.expectNoEvents(Optional.empty());
            byte[] key = HotRodTestingUtil.k(m);
            this.client().replace(key, 0, 0, HotRodTestingUtil.v(m));
            eventListener.expectNoEvents(Optional.empty());
            this.client().put(key, 0, 0, HotRodTestingUtil.v(m));
            eventListener.expectOnlyCreatedEvent(this.cache, key);
            this.client().replace(key, 0, 0, HotRodTestingUtil.v(m, "v2-"));
            eventListener.expectOnlyModifiedEvent(this.cache, key);
        });
    }

    public void testPutIfAbsentEvents(Method m) {
        EventLogListener eventListener = new EventLogListener();
        HotRodTestingUtil.withClientListener(this.client(), eventListener, Optional.empty(), Optional.empty(), () -> {
            eventListener.expectNoEvents(Optional.empty());
            byte[] key = HotRodTestingUtil.k(m);
            this.client().putIfAbsent(key, 0, 0, HotRodTestingUtil.v(m));
            eventListener.expectOnlyCreatedEvent(this.cache, key);
            this.client().putIfAbsent(key, 0, 0, HotRodTestingUtil.v(m, "v2-"));
            eventListener.expectNoEvents(Optional.empty());
        });
    }

    public void testReplaceIfUnmodifiedEvents(Method m) {
        EventLogListener eventListener = new EventLogListener();
        HotRodTestingUtil.withClientListener(this.client(), eventListener, Optional.empty(), Optional.empty(), () -> {
            eventListener.expectNoEvents(Optional.empty());
            byte[] key = HotRodTestingUtil.k(m);
            this.client().replaceIfUnmodified(key, 0, 0, HotRodTestingUtil.v(m), 0L);
            eventListener.expectNoEvents(Optional.empty());
            this.client().put(key, 0, 0, HotRodTestingUtil.v(m));
            eventListener.expectOnlyCreatedEvent(this.cache, key);
            this.client().replaceIfUnmodified(key, 0, 0, HotRodTestingUtil.v(m), 0L);
            eventListener.expectNoEvents(Optional.empty());
            TestGetWithVersionResponse resp = this.client().getWithVersion(HotRodTestingUtil.k(m), 0);
            HotRodTestingUtil.assertSuccess(resp, HotRodTestingUtil.v(m), 0);
            this.client().replaceIfUnmodified(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v1-"), resp.dataVersion);
            eventListener.expectOnlyModifiedEvent(this.cache, key);
        });
    }

    public void testRemoveIfUnmodifiedEvents(Method m) {
        EventLogListener eventListener = new EventLogListener();
        HotRodTestingUtil.withClientListener(this.client(), eventListener, Optional.empty(), Optional.empty(), () -> {
            eventListener.expectNoEvents(Optional.empty());
            byte[] key = HotRodTestingUtil.k(m);
            this.client().removeIfUnmodified(key, 0, 0, HotRodTestingUtil.v(m), 0L);
            eventListener.expectNoEvents(Optional.empty());
            this.client().put(key, 0, 0, HotRodTestingUtil.v(m));
            eventListener.expectOnlyCreatedEvent(this.cache, key);
            this.client().removeIfUnmodified(key, 0, 0, HotRodTestingUtil.v(m), 0L);
            eventListener.expectNoEvents(Optional.empty());
            TestGetWithVersionResponse resp = this.client().getWithVersion(HotRodTestingUtil.k(m), 0);
            HotRodTestingUtil.assertSuccess(resp, HotRodTestingUtil.v(m), 0);
            this.client().removeIfUnmodified(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v1-"), resp.dataVersion);
            eventListener.expectOnlyRemovedEvent(this.cache, key);
        });
    }

    public void testClearEvents(Method m) {
        EventLogListener eventListener = new EventLogListener();
        HotRodTestingUtil.withClientListener(this.client(), eventListener, Optional.empty(), Optional.empty(), () -> {
            eventListener.expectNoEvents(Optional.empty());
            byte[] key1 = HotRodTestingUtil.k(m, "k1");
            byte[] key2 = HotRodTestingUtil.k(m, "k2");
            byte[] key3 = HotRodTestingUtil.k(m, "k3");
            this.client().put(key1, 0, 0, HotRodTestingUtil.v(m));
            eventListener.expectOnlyCreatedEvent(this.cache, key1);
            this.client().put(key2, 0, 0, HotRodTestingUtil.v(m));
            eventListener.expectOnlyCreatedEvent(this.cache, key2);
            this.client().put(key3, 0, 0, HotRodTestingUtil.v(m));
            eventListener.expectOnlyCreatedEvent(this.cache, key3);
            this.client().clear();
            List<byte[]> keys = Arrays.asList(key1, key2, key3);
            eventListener.expectUnorderedEvents(this.cache, keys, Event.Type.CACHE_ENTRY_REMOVED);
        });
    }

    public void testNoEventsBeforeAddingListener(Method m) {
        EventLogListener eventListener = new EventLogListener();
        byte[] key = HotRodTestingUtil.k(m);
        this.client().put(key, 0, 0, HotRodTestingUtil.v(m));
        eventListener.expectNoEvents(Optional.empty());
        this.client().put(key, 0, 0, HotRodTestingUtil.v(m, "v2-"));
        eventListener.expectNoEvents(Optional.empty());
        this.client().remove(key);
        HotRodTestingUtil.withClientListener(this.client(), eventListener, Optional.empty(), Optional.empty(), () -> {
            byte[] key2 = HotRodTestingUtil.k(m, "k2-");
            this.client().put(key2, 0, 0, HotRodTestingUtil.v(m));
            eventListener.expectSingleEvent(this.cache, key2, Event.Type.CACHE_ENTRY_CREATED);
            this.client().put(key2, 0, 0, HotRodTestingUtil.v(m, "v2-"));
            eventListener.expectSingleEvent(this.cache, key2, Event.Type.CACHE_ENTRY_MODIFIED);
            this.client().remove(key2);
            eventListener.expectSingleEvent(this.cache, key2, Event.Type.CACHE_ENTRY_REMOVED);
        });
    }

    public void testNoEventsAfterRemovingListener(Method m) {
        EventLogListener eventListener = new EventLogListener();
        HotRodTestingUtil.withClientListener(this.client(), eventListener, Optional.empty(), Optional.empty(), () -> {
            byte[] key = HotRodTestingUtil.k(m);
            this.client().put(key, 0, 0, HotRodTestingUtil.v(m));
            eventListener.expectSingleEvent(this.cache, key, Event.Type.CACHE_ENTRY_CREATED);
            this.client().put(key, 0, 0, HotRodTestingUtil.v(m, "v2-"));
            eventListener.expectSingleEvent(this.cache, key, Event.Type.CACHE_ENTRY_MODIFIED);
            this.client().remove(key);
            eventListener.expectSingleEvent(this.cache, key, Event.Type.CACHE_ENTRY_REMOVED);
        });
        byte[] key = HotRodTestingUtil.k(m, "k2-");
        this.client().put(key, 0, 0, HotRodTestingUtil.v(m));
        eventListener.expectNoEvents(Optional.empty());
        this.client().put(key, 0, 0, HotRodTestingUtil.v(m, "v2-"));
        eventListener.expectNoEvents(Optional.empty());
        this.client().remove(key);
        eventListener.expectNoEvents(Optional.empty());
    }

    public void testEventReplayAfterAddingListener(Method m) {
        EventLogListener eventListener = new EventLogListener();
        byte[] k1 = HotRodTestingUtil.k(m, "k1-");
        byte[] v1 = HotRodTestingUtil.v(m, "v1-");
        byte[] k2 = HotRodTestingUtil.k(m, "k2-");
        byte[] v2 = HotRodTestingUtil.v(m, "v2-");
        byte[] k3 = HotRodTestingUtil.k(m, "k3-");
        byte[] v3 = HotRodTestingUtil.v(m, "v3-");
        this.client().put(k1, 0, 0, v1);
        this.client().put(k2, 0, 0, v2);
        this.client().put(k3, 0, 0, v3);
        HotRodTestingUtil.withClientListener(this.client(), eventListener, Optional.empty(), Optional.empty(), true, true, () -> eventListener.expectUnorderedEvents(this.cache, Arrays.asList(k1, k2, k3), Event.Type.CACHE_ENTRY_CREATED));
    }
}

