/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.event;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodSingleNodeTest;
import org.infinispan.server.hotrod.event.AbstractHotRodClusterEventsTest;
import org.infinispan.server.hotrod.event.EventLogListener;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.util.KeyValuePair;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.event.HotRodCustomEventsTest")
public class HotRodCustomEventsTest
extends HotRodSingleNodeTest {
    @Override
    protected HotRodServer createStartHotRodServer(EmbeddedCacheManager cacheManager) {
        HotRodServer server = HotRodTestingUtil.startHotRodServer(cacheManager);
        server.addCacheEventConverterFactory("static-converter-factory", (CacheEventConverterFactory)new StaticConverterFactory());
        server.addCacheEventConverterFactory("dynamic-converter-factory", (CacheEventConverterFactory)new DynamicConverterFactory());
        return server;
    }

    public void testCustomEvents(Method m) {
        EventLogListener eventListener = new EventLogListener();
        HotRodTestingUtil.withClientListener(this.client(), eventListener, Optional.empty(), Optional.of(new KeyValuePair((Object)"static-converter-factory", Collections.emptyList())), () -> {
            eventListener.expectNoEvents(Optional.empty());
            byte[] key = HotRodTestingUtil.k(m);
            this.client().remove(key);
            eventListener.expectNoEvents(Optional.empty());
            byte[] value = HotRodTestingUtil.v(m);
            this.client().put(key, 0, 0, value);
            eventListener.expectSingleCustomEvent(this.cache, AbstractHotRodClusterEventsTest.addLengthPrefix(key, value));
            byte[] value2 = HotRodTestingUtil.v(m, "v2-");
            this.client().put(key, 0, 0, value2);
            eventListener.expectSingleCustomEvent(this.cache, AbstractHotRodClusterEventsTest.addLengthPrefix(key, value2));
            this.client().remove(key);
            eventListener.expectSingleCustomEvent(this.cache, AbstractHotRodClusterEventsTest.addLengthPrefix(key));
        });
    }

    public void testParameterBasedConversion(Method m) {
        EventLogListener eventListener = new EventLogListener();
        byte[] customConvertKey = new byte[]{4, 5, 6};
        HotRodTestingUtil.withClientListener(this.client(), eventListener, Optional.empty(), Optional.of(new KeyValuePair((Object)"dynamic-converter-factory", Collections.singletonList(new byte[]{4, 5, 6}))), () -> {
            eventListener.expectNoEvents(Optional.empty());
            byte[] key = HotRodTestingUtil.k(m);
            byte[] value = HotRodTestingUtil.v(m);
            this.client().put(key, 0, 0, value);
            eventListener.expectSingleCustomEvent(this.cache, AbstractHotRodClusterEventsTest.addLengthPrefix(key, value));
            byte[] value2 = HotRodTestingUtil.v(m, "v2-");
            this.client().put(key, 0, 0, value2);
            eventListener.expectSingleCustomEvent(this.cache, AbstractHotRodClusterEventsTest.addLengthPrefix(key, value2));
            this.client().remove(key);
            eventListener.expectSingleCustomEvent(this.cache, AbstractHotRodClusterEventsTest.addLengthPrefix(key));
            this.client().put(customConvertKey, 0, 0, value);
            eventListener.expectSingleCustomEvent(this.cache, AbstractHotRodClusterEventsTest.addLengthPrefix(customConvertKey));
        });
    }

    public void testConvertedEventsNoReplay(Method m) {
        EventLogListener eventListener = new EventLogListener();
        byte[] key = new byte[]{1};
        byte[] value = new byte[]{2};
        this.client().put(key, 0, 0, value);
        HotRodTestingUtil.withClientListener(this.client(), eventListener, Optional.empty(), Optional.of(new KeyValuePair((Object)"static-converter-factory", Collections.emptyList())), () -> eventListener.expectNoEvents(Optional.empty()));
    }

    public void testConvertedEventsReplay(Method m) {
        EventLogListener eventListener = new EventLogListener();
        byte[] key = new byte[]{1};
        byte[] value = new byte[]{2};
        this.client().put(key, 0, 0, value);
        HotRodTestingUtil.withClientListener(this.client(), eventListener, Optional.empty(), Optional.of(new KeyValuePair((Object)"static-converter-factory", Collections.emptyList())), true, true, () -> eventListener.expectSingleCustomEvent(this.cache, AbstractHotRodClusterEventsTest.addLengthPrefix(key, value)));
    }

    class DynamicConverterFactory
    implements CacheEventConverterFactory {
        DynamicConverterFactory() {
        }

        public <K, V, C> CacheEventConverter<K, V, C> getConverter(Object[] params) {
            return (key, oldValue, oldMetadata, newValue, newMetadata, eventType) -> {
                if (newValue == null || Arrays.equals((byte[])params[0], key)) {
                    return AbstractHotRodClusterEventsTest.addLengthPrefix(key);
                }
                return AbstractHotRodClusterEventsTest.addLengthPrefix(key, newValue);
            };
        }
    }

    private static class StaticConverterFactory
    implements CacheEventConverterFactory {
        private StaticConverterFactory() {
        }

        public <K, V, C> CacheEventConverter<K, V, C> getConverter(Object[] params) {
            return (key, oldValue, oldMetadata, newValue, newMetadata, eventType) -> {
                if (newValue == null) {
                    return AbstractHotRodClusterEventsTest.addLengthPrefix(key);
                }
                return AbstractHotRodClusterEventsTest.addLengthPrefix(key, newValue);
            };
        }
    }
}

