/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.counter.impl;

import java.util.concurrent.CompletableFuture;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.api.SyncWeakCounter;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.counter.exception.CounterException;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.counter.impl.TestCounterNotificationManager;
import org.infinispan.server.hotrod.counter.op.CounterAddOp;
import org.infinispan.server.hotrod.counter.op.CounterOp;
import org.infinispan.server.hotrod.counter.response.CounterValueTestResponse;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.TestErrorResponse;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.util.concurrent.CompletableFutures;

class TestWeakCounter
implements WeakCounter {
    private final String name;
    private final CounterConfiguration configuration;
    private final HotRodClient client;
    private final TestCounterNotificationManager notificationManager;

    TestWeakCounter(String name, CounterConfiguration configuration, HotRodClient client, TestCounterNotificationManager notificationManager) {
        this.name = name;
        this.configuration = configuration;
        this.client = client;
        this.notificationManager = notificationManager;
    }

    public String getName() {
        return this.name;
    }

    public long getValue() {
        CounterOp op = new CounterOp(this.client.protocolVersion(), HotRodOperation.COUNTER_GET, this.name);
        this.client.writeOp(op);
        TestResponse response = this.client.getResponse(op);
        switch (response.getStatus()) {
            case Success: {
                return ((CounterValueTestResponse)response).getValue();
            }
            case ServerError: {
                throw new CounterException(((TestErrorResponse)response).msg);
            }
        }
        throw new CounterException("unknown response " + response);
    }

    public CompletableFuture<Void> add(long delta) {
        CounterAddOp op = new CounterAddOp(this.client.protocolVersion(), this.name, delta);
        return this.executeOp(op);
    }

    public CompletableFuture<Void> reset() {
        CounterOp op = new CounterOp(this.client.protocolVersion(), HotRodOperation.COUNTER_RESET, this.name);
        return this.executeOp(op);
    }

    public <T extends CounterListener> Handle<T> addListener(T listener) {
        return this.notificationManager.register(this.name, listener);
    }

    public CounterConfiguration getConfiguration() {
        return this.configuration;
    }

    public CompletableFuture<Void> remove() {
        CounterOp op = new CounterOp(this.client.protocolVersion(), HotRodOperation.COUNTER_REMOVE, this.name);
        this.client.writeOp(op);
        this.client.getResponse(op);
        return CompletableFutures.completedNull();
    }

    public SyncWeakCounter sync() {
        throw new UnsupportedOperationException();
    }

    private CompletableFuture<Void> executeOp(CounterOp op) {
        this.client.writeOp(op);
        TestResponse response = this.client.getResponse(op);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        switch (response.getStatus()) {
            case Success: {
                future.complete(null);
                break;
            }
            case OperationNotExecuted: {
                future.complete(null);
                break;
            }
            case KeyDoesNotExist: {
                future.completeExceptionally(new IllegalStateException("Counter Not Found!"));
                break;
            }
            case ServerError: {
                future.completeExceptionally((Throwable)new CounterException(((TestErrorResponse)response).msg));
                break;
            }
            default: {
                future.completeExceptionally(new Exception("unknown response " + response));
            }
        }
        return future;
    }
}

