/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.counter.impl;

import io.netty.buffer.ByteBuf;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.counter.api.CounterEvent;
import org.infinispan.counter.api.CounterState;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.counter.listener.ClientCounterEvent;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.server.hotrod.transport.ExtendedByteBuf;

public class TestCounterEventResponse
extends TestResponse {
    private final String counterName;
    private final WrappedByteArray listenerId;
    private final CounterEvent counterEvent;

    public TestCounterEventResponse(byte version, long messageId, HotRodOperation operation, ByteBuf buffer) {
        super(version, messageId, "", (short)0, operation, OperationStatus.Success, 0, null);
        this.counterName = ExtendedByteBuf.readString((ByteBuf)buffer);
        this.listenerId = new WrappedByteArray(ExtendedByteBuf.readRangedBytes((ByteBuf)buffer));
        byte counterState = buffer.readByte();
        this.counterEvent = new CounterEventImpl(buffer.readLong(), ClientCounterEvent.decodeOldState((byte)counterState), buffer.readLong(), ClientCounterEvent.decodeNewState((byte)counterState));
    }

    public String getCounterName() {
        return this.counterName;
    }

    public WrappedByteArray getListenerId() {
        return this.listenerId;
    }

    CounterEvent getCounterEvent() {
        return this.counterEvent;
    }

    private static class CounterEventImpl
    implements CounterEvent {
        private final long oldValue;
        private final CounterState oldState;
        private final long newValue;
        private final CounterState newState;

        private CounterEventImpl(long oldValue, CounterState oldState, long newValue, CounterState newState) {
            this.oldValue = oldValue;
            this.oldState = oldState;
            this.newValue = newValue;
            this.newState = newState;
        }

        public long getOldValue() {
            return this.oldValue;
        }

        public CounterState getOldState() {
            return this.oldState;
        }

        public long getNewValue() {
            return this.newValue;
        }

        public CounterState getNewState() {
            return this.newState;
        }
    }
}

