/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.counter.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.impl.Util;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.counter.CounterManagerTestStrategy;
import org.infinispan.util.logging.Log;
import org.testng.AssertJUnit;

public class CounterManagerImplTestStrategy
implements CounterManagerTestStrategy {
    private final Supplier<List<CounterManager>> allRemoteCounterManagerSupplier;
    private final Supplier<Log> logSupplier;
    private final Supplier<EmbeddedCacheManager> cacheManagerSupplier;

    public CounterManagerImplTestStrategy(Supplier<List<CounterManager>> allRemoteCounterManagerSupplier, Supplier<Log> logSupplier, Supplier<EmbeddedCacheManager> cacheManagerSupplier) {
        this.allRemoteCounterManagerSupplier = allRemoteCounterManagerSupplier;
        this.logSupplier = logSupplier;
        this.cacheManagerSupplier = cacheManagerSupplier;
    }

    @Override
    public void testWeakCounter(Method method) {
        Random random = this.generateRandom();
        String counterName = method.getName();
        CounterConfiguration config = CounterConfiguration.builder((CounterType)CounterType.WEAK).initialValue((long)random.nextInt()).storage(random.nextBoolean() ? Storage.VOLATILE : Storage.PERSISTENT).concurrencyLevel(Math.abs(random.nextInt())).build();
        this.doCreationTest(counterName, config);
    }

    @Override
    public void testUnboundedStrongCounter(Method method) {
        Random random = this.generateRandom();
        String counterName = method.getName();
        CounterConfiguration config = CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).initialValue((long)random.nextInt()).storage(random.nextBoolean() ? Storage.VOLATILE : Storage.PERSISTENT).build();
        this.doCreationTest(counterName, config);
    }

    @Override
    public void testUpperBoundedStrongCounter(Method method) {
        Random random = this.generateRandom();
        String counterName = method.getName();
        CounterConfiguration config = CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).initialValue(5L).upperBound(15L).storage(random.nextBoolean() ? Storage.VOLATILE : Storage.PERSISTENT).build();
        this.doCreationTest(counterName, config);
    }

    @Override
    public void testLowerBoundedStrongCounter(Method method) {
        Random random = this.generateRandom();
        String counterName = method.getName();
        CounterConfiguration config = CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).initialValue(15L).lowerBound(5L).storage(random.nextBoolean() ? Storage.VOLATILE : Storage.PERSISTENT).build();
        this.doCreationTest(counterName, config);
    }

    @Override
    public void testBoundedStrongCounter(Method method) {
        Random random = this.generateRandom();
        String counterName = method.getName();
        CounterConfiguration config = CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).initialValue(15L).lowerBound(5L).upperBound(20L).storage(random.nextBoolean() ? Storage.VOLATILE : Storage.PERSISTENT).build();
        this.doCreationTest(counterName, config);
    }

    @Override
    public void testUndefinedCounter() {
        CounterManager counterManager = this.getTestedCounterManager();
        AssertJUnit.assertFalse((boolean)counterManager.isDefined("not-defined-counter"));
        AssertJUnit.assertEquals(null, (Object)counterManager.getConfiguration("not-defined-counter"));
    }

    @Override
    public void testRemove(Method method) {
        this.clearCaches();
        Random random = this.generateRandom();
        String counterName = method.getName();
        CounterManager counterManager = this.getTestedCounterManager();
        CounterConfiguration config = CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).initialValue(random.nextLong()).build();
        AssertJUnit.assertTrue((boolean)counterManager.defineCounter(counterName, config));
        Util.awaitCounterOperation((CompletableFuture)counterManager.getStrongCounter(counterName).addAndGet(10L));
        EmbeddedCacheManager cacheManager = this.cacheManagerSupplier.get();
        Cache cache = cacheManager.getCache("org.infinispan.COUNTER");
        AssertJUnit.assertEquals((int)1, (int)cache.size());
        counterManager.remove(counterName);
        AssertJUnit.assertEquals((int)0, (int)cache.size());
    }

    @Override
    public void testGetCounterNames(Method method) {
        this.clearCaches();
        Random random = this.generateRandom();
        String counterNamePrefix = method.getName();
        CounterManager counterManager = this.getTestedCounterManager();
        int numCounters = random.nextInt(10) + 1;
        ArrayList<CounterConfiguration> configList = new ArrayList<CounterConfiguration>(numCounters);
        HashSet<String> counterSet = new HashSet<String>();
        for (int i = 0; i < numCounters; ++i) {
            CounterConfiguration config = CounterConfiguration.builder((CounterType)CounterType.valueOf((int)random.nextInt(3))).initialValue(random.nextLong()).build();
            AssertJUnit.assertTrue((boolean)counterManager.defineCounter(counterNamePrefix + i, config));
            configList.add(config);
            counterSet.add(counterNamePrefix + i);
        }
        HashSet counterNames = new HashSet(counterManager.getCounterNames());
        AssertJUnit.assertEquals(counterSet, counterNames);
        for (int i = 0; i < numCounters; ++i) {
            String counterName = counterNamePrefix + i;
            AssertJUnit.assertTrue((boolean)counterNames.contains(counterName));
            CounterConfiguration config = (CounterConfiguration)configList.get(i);
            CounterConfiguration storedConfig = config.type() == CounterType.WEAK ? counterManager.getWeakCounter(counterName).getConfiguration() : counterManager.getStrongCounter(counterName).getConfiguration();
            AssertJUnit.assertEquals((Object)config, (Object)storedConfig);
        }
    }

    private Random generateRandom() {
        long seed = System.nanoTime();
        this.logSupplier.get().debugf("Using SEED: '%d'", seed);
        return new Random(seed);
    }

    private void doCreationTest(String name, CounterConfiguration config) {
        List<CounterManager> remoteCounterManagers = this.allRemoteCounterManagerSupplier.get();
        AssertJUnit.assertTrue((boolean)remoteCounterManagers.get(0).defineCounter(name, config));
        remoteCounterManagers.forEach(cm -> AssertJUnit.assertFalse((boolean)cm.defineCounter(name, CounterConfiguration.builder((CounterType)CounterType.WEAK).build())));
        remoteCounterManagers.forEach(cm -> AssertJUnit.assertTrue((boolean)cm.isDefined(name)));
        remoteCounterManagers.forEach(cm -> AssertJUnit.assertEquals((Object)config, (Object)cm.getConfiguration(name)));
        EmbeddedCacheManager cacheManager = this.cacheManagerSupplier.get();
        CounterManager counterManager = EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)cacheManager);
        AssertJUnit.assertTrue((boolean)counterManager.isDefined(name));
        AssertJUnit.assertEquals((Object)config, (Object)counterManager.getConfiguration(name));
    }

    private CounterManager getTestedCounterManager() {
        return this.allRemoteCounterManagerSupplier.get().get(0);
    }

    private void clearCaches() {
        EmbeddedCacheManager cacheManager = this.cacheManagerSupplier.get();
        cacheManager.getCache("org.infinispan.COUNTER").clear();
        cacheManager.getCache("org.infinispan.CONFIG").keySet().removeIf(o -> "counter".equals(o.getScope()));
    }
}

