/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import java.util.Map;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodMagicKeyGenerator;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRodStatsClusterTest")
public class HotRodStatsClusterTest
extends HotRodMultiNodeTest {
    @Override
    protected byte protocolVersion() {
        return 24;
    }

    @Override
    protected String cacheName() {
        return "hotRodClusterStats";
    }

    @Override
    protected ConfigurationBuilder createCacheConfig() {
        ConfigurationBuilder config = HotRodTestingUtil.hotRodCacheConfiguration(HotRodStatsClusterTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        config.jmxStatistics().enable();
        config.clustering().hash().numOwners(1);
        return config;
    }

    public void testClusterStats(Method m) throws Exception {
        HotRodClient client1 = this.clients().get(0);
        HotRodClient client2 = this.clients().get(1);
        byte[] key1 = HotRodMagicKeyGenerator.newKey(this.cache(0, this.cacheName()));
        byte[] value = HotRodTestingUtil.v(m, "v1-");
        TestResponse resp = client1.put(key1, 0, 0, value, (byte)3, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertSuccess(client1.get(key1, 0), value);
        client1.remove(HotRodTestingUtil.k(m));
        Map<String, String> stats1 = client1.stats();
        AssertJUnit.assertEquals((String)stats1.get("currentNumberOfEntries"), (String)"1");
        AssertJUnit.assertEquals((String)stats1.get("totalNumberOfEntries"), (String)"1");
        AssertJUnit.assertEquals((String)stats1.get("stores"), (String)"1");
        AssertJUnit.assertEquals((String)stats1.get("hits"), (String)"1");
        AssertJUnit.assertEquals((String)stats1.get("retrievals"), (String)"1");
        AssertJUnit.assertEquals((String)stats1.get("removeMisses"), (String)"1");
        AssertJUnit.assertEquals((String)stats1.get("globalCurrentNumberOfEntries"), (String)"1");
        AssertJUnit.assertEquals((String)stats1.get("globalStores"), (String)"1");
        AssertJUnit.assertEquals((String)stats1.get("globalHits"), (String)"1");
        AssertJUnit.assertEquals((String)stats1.get("globalRetrievals"), (String)"1");
        AssertJUnit.assertEquals((String)stats1.get("globalRemoveMisses"), (String)"1");
        Map<String, String> stats2 = client2.stats();
        AssertJUnit.assertEquals((String)stats2.get("currentNumberOfEntries"), (String)"0");
        AssertJUnit.assertEquals((String)stats2.get("totalNumberOfEntries"), (String)"0");
        AssertJUnit.assertEquals((String)stats2.get("stores"), (String)"0");
        AssertJUnit.assertEquals((String)stats2.get("hits"), (String)"0");
        AssertJUnit.assertEquals((String)stats2.get("retrievals"), (String)"0");
        AssertJUnit.assertEquals((String)stats2.get("removeMisses"), (String)"0");
        AssertJUnit.assertEquals((String)stats2.get("globalCurrentNumberOfEntries"), (String)"1");
        AssertJUnit.assertEquals((String)stats2.get("globalStores"), (String)"1");
        AssertJUnit.assertEquals((String)stats2.get("globalHits"), (String)"1");
        AssertJUnit.assertEquals((String)stats2.get("globalRetrievals"), (String)"1");
        AssertJUnit.assertEquals((String)stats2.get("globalRemoveMisses"), (String)"1");
        TestingUtil.sleepThread((long)5000L);
        client1.remove(key1);
        HotRodTestingUtil.assertKeyDoesNotExist(client1.get(key1, 0));
        stats1 = client1.stats();
        AssertJUnit.assertEquals((String)stats1.get("misses"), (String)"1");
        AssertJUnit.assertEquals((String)stats1.get("removeHits"), (String)"1");
        AssertJUnit.assertEquals((String)stats1.get("globalMisses"), (String)"1");
        AssertJUnit.assertEquals((String)stats1.get("globalRemoveHits"), (String)"1");
        stats2 = client2.stats();
        AssertJUnit.assertEquals((String)stats2.get("misses"), (String)"0");
        AssertJUnit.assertEquals((String)stats2.get("removeHits"), (String)"0");
        AssertJUnit.assertEquals((String)stats2.get("globalMisses"), (String)"1");
        AssertJUnit.assertEquals((String)stats2.get("globalRemoveHits"), (String)"1");
    }
}

