/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.test.AbstractTestTopologyAwareResponse;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.server.hotrod.test.TestSizeResponse;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRodReplicationTest")
public class HotRodReplicationTest
extends HotRodMultiNodeTest {
    @Override
    protected String cacheName() {
        return "hotRodReplSync";
    }

    @Override
    protected ConfigurationBuilder createCacheConfig() {
        ConfigurationBuilder config = HotRodTestingUtil.hotRodCacheConfiguration(HotRodReplicationTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false));
        config.clustering().stateTransfer().fetchInMemoryState(true);
        return config;
    }

    public void testReplicatedPut(Method m) {
        TestResponse resp = this.clients().get(0).put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertSuccess(this.clients().get(1).get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m));
    }

    public void testReplicatedPutIfAbsent(Method m) {
        HotRodTestingUtil.assertKeyDoesNotExist(this.clients().get(0).assertGet(m));
        HotRodTestingUtil.assertKeyDoesNotExist(this.clients().get(1).assertGet(m));
        TestResponse resp = this.clients().get(0).putIfAbsent(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertSuccess(this.clients().get(1).get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m));
        HotRodTestingUtil.assertStatus(this.clients().get(1).putIfAbsent(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v2-")), OperationStatus.OperationNotExecuted);
    }

    public void testReplicatedReplace(Method m) {
        TestResponse resp = this.clients().get(0).replace(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.OperationNotExecuted);
        resp = this.clients().get(1).replace(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.OperationNotExecuted);
        this.clients().get(1).assertPut(m);
        resp = this.clients().get(1).replace(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v1-"));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertSuccess(this.clients().get(0).assertGet(m), HotRodTestingUtil.v(m, "v1-"));
        resp = this.clients().get(0).replace(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v2-"));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertSuccess(this.clients().get(1).assertGet(m), HotRodTestingUtil.v(m, "v2-"));
    }

    public void testPingWithTopologyAwareClient() {
        TestResponse resp = this.clients().get(0).ping();
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        AssertJUnit.assertEquals((Object)resp.topologyResponse, null);
        resp = this.clients().get(1).ping((byte)1, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        AssertJUnit.assertEquals((Object)resp.topologyResponse, null);
        resp = this.clients().get(0).ping((byte)2, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertTopologyReceived(resp.topologyResponse, this.servers(), this.currentServerTopologyId());
        resp = this.clients().get(1).ping((byte)2, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertTopologyReceived(resp.topologyResponse, this.servers(), this.currentServerTopologyId());
        resp = this.clients().get(1).ping((byte)2, 1 + 2 * this.nodeCount());
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        AssertJUnit.assertEquals((Object)resp.topologyResponse, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReplicatedPutWithTopologyChanges(Method m) {
        TestResponse resp = this.clients().get(0).put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), (byte)1, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        AssertJUnit.assertEquals((Object)resp.topologyResponse, null);
        HotRodTestingUtil.assertSuccess(this.clients().get(1).get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m));
        resp = this.clients().get(0).put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v1-"), (byte)2, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertTopologyReceived(resp.topologyResponse, this.servers(), this.currentServerTopologyId());
        resp = this.clients().get(1).put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v2-"), (byte)2, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertTopologyReceived(resp.topologyResponse, this.servers(), this.currentServerTopologyId());
        resp = this.clients().get(0).put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v3-"), (byte)2, 1 + 2 * this.nodeCount());
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        AssertJUnit.assertEquals((Object)resp.topologyResponse, null);
        HotRodTestingUtil.assertSuccess(this.clients().get(1).get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m, "v3-"));
        HotRodServer newServer = this.startClusteredServer(this.servers().get(1).getPort() + 25);
        try {
            resp = this.clients().get(0).put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v4-"), (byte)2, 1 + 2 * this.nodeCount());
            HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
            AssertJUnit.assertEquals((int)resp.topologyResponse.topologyId, (int)this.currentServerTopologyId());
            AbstractTestTopologyAwareResponse topoResp = resp.asTopologyAwareResponse();
            AssertJUnit.assertEquals((int)topoResp.members.size(), (int)3);
            Stream.concat(Stream.of(newServer), this.servers().stream()).map(HotRodServer::getAddress).forEach(serverAddress -> AssertJUnit.assertTrue((boolean)topoResp.members.contains(serverAddress)));
            HotRodTestingUtil.assertSuccess(this.clients().get(1).get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m, "v4-"));
        }
        catch (Throwable throwable) {
            this.stopClusteredServer(newServer);
            TestingUtil.waitForNoRebalance((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
            throw throwable;
        }
        this.stopClusteredServer(newServer);
        TestingUtil.waitForNoRebalance((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
        resp = this.clients().get(0).put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v5-"), (byte)2, 1 + 2 * this.nodeCount() + 2);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        AssertJUnit.assertEquals((int)resp.topologyResponse.topologyId, (int)this.currentServerTopologyId());
        AbstractTestTopologyAwareResponse topoResp3 = resp.asTopologyAwareResponse();
        AssertJUnit.assertEquals((int)topoResp3.members.size(), (int)2);
        this.servers().stream().map(HotRodServer::getAddress).forEach(addr -> AssertJUnit.assertTrue((boolean)topoResp3.members.contains(addr)));
        HotRodTestingUtil.assertSuccess(this.clients().get(1).get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m, "v5-"));
        HotRodServer crashingServer = this.startClusteredServer(this.servers().get(1).getPort() + 25);
        try {
            resp = this.clients().get(0).put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v6-"), (byte)2, 1 + 2 * this.nodeCount() + 4);
            HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
            AssertJUnit.assertEquals((int)resp.topologyResponse.topologyId, (int)this.currentServerTopologyId());
            AbstractTestTopologyAwareResponse topoResp2 = resp.asTopologyAwareResponse();
            AssertJUnit.assertEquals((int)topoResp2.members.size(), (int)3);
            Stream.concat(Stream.of(crashingServer), this.servers().stream()).map(HotRodServer::getAddress).forEach(addr -> AssertJUnit.assertTrue((boolean)topoResp2.members.contains(addr)));
            HotRodTestingUtil.assertSuccess(this.clients().get(1).get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m, "v6-"));
        }
        catch (Throwable throwable) {
            this.stopClusteredServer(crashingServer);
            TestingUtil.waitForNoRebalance((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
            throw throwable;
        }
        this.stopClusteredServer(crashingServer);
        TestingUtil.waitForNoRebalance((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
        resp = this.clients().get(0).put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v7-"), (byte)2, 1 + 2 * this.nodeCount() + 6);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        AssertJUnit.assertEquals((int)resp.topologyResponse.topologyId, (int)this.currentServerTopologyId());
        AbstractTestTopologyAwareResponse topoResp4 = resp.asTopologyAwareResponse();
        AssertJUnit.assertEquals((int)topoResp4.members.size(), (int)2);
        this.servers().stream().map(HotRodServer::getAddress).forEach(addr -> AssertJUnit.assertTrue((boolean)topoResp4.members.contains(addr)));
        HotRodTestingUtil.assertSuccess(this.clients().get(1).get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m, "v7-"));
        resp = this.clients().get(0).put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v8-"), (byte)3, 1);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        this.checkTopologyReceived(resp.topologyResponse, this.servers(), this.cacheName());
        HotRodTestingUtil.assertSuccess(this.clients().get(1).get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m, "v8-"));
    }

    public void testSize(Method m) {
        String newCacheName = "repl-size";
        this.defineCaches(newCacheName);
        List<HotRodClient> newClients = this.createClients(newCacheName);
        TestSizeResponse sizeStart = newClients.get(0).size();
        HotRodTestingUtil.assertStatus(sizeStart, OperationStatus.Success);
        AssertJUnit.assertEquals((long)0L, (long)sizeStart.size);
        for (int i = 0; i < 20; ++i) {
            newClients.get(1).assertPut(m, "k-" + i, "v-" + i);
        }
        TestSizeResponse sizeEnd = newClients.get(1).size();
        HotRodTestingUtil.assertStatus(sizeEnd, OperationStatus.Success);
        AssertJUnit.assertEquals((long)20L, (long)sizeEnd.size);
    }

    protected void checkTopologyReceived(AbstractTestTopologyAwareResponse topoResp, List<HotRodServer> servers, String cacheName) {
        HotRodTestingUtil.assertHashTopology20Received(topoResp, servers, cacheName, this.currentServerTopologyId());
    }
}

