/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.protostream.AnnotationMetadataCreator;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.Option;
import org.infinispan.query.remote.impl.indexing.FieldMapping;
import org.infinispan.query.remote.impl.indexing.IndexingMetadataCreator;

public final class IndexingMetadata {
    private static final String INDEXED_BY_DEFAULT_OPTION = "indexed_by_default";
    public static final String INDEXED_ANNOTATION = "Indexed";
    public static final String INDEXED_INDEX_ATTRIBUTE = "index";
    @Deprecated
    public static final String INDEXED_FIELD_ANNOTATION = "IndexedField";
    @Deprecated
    public static final String INDEXED_FIELD_INDEX_ATTRIBUTE = "index";
    @Deprecated
    public static final String INDEXED_FIELD_STORE_ATTRIBUTE = "store";
    public static final String FIELDS_ANNOTATION = "Fields";
    public static final String FIELD_ANNOTATION = "Field";
    public static final String FIELD_NAME_ATTRIBUTE = "name";
    public static final String FIELD_INDEX_ATTRIBUTE = "index";
    public static final String FIELD_BOOST_ATTRIBUTE = "boost";
    public static final String FIELD_ANALYZE_ATTRIBUTE = "analyze";
    public static final String FIELD_STORE_ATTRIBUTE = "store";
    public static final String FIELD_ANALYZER_ATTRIBUTE = "analyzer";
    public static final String FIELD_INDEX_NULL_AS_ATTRIBUTE = "indexNullAs";
    public static final String INDEX_YES = "Index.YES";
    public static final String INDEX_NO = "Index.NO";
    public static final String ANALYZE_YES = "Analyze.YES";
    public static final String ANALYZE_NO = "Analyze.NO";
    public static final String STORE_YES = "Store.YES";
    public static final String STORE_NO = "Store.NO";
    public static final String DEFAULT_NULL_TOKEN = "_null_";
    public static final String DO_NOT_INDEX_NULL = "__DO_NOT_INDEX_NULL__";
    public static final String ANALYZER_ANNOTATION = "Analyzer";
    public static final String ANALYZER_DEFINITION_ATTRIBUTE = "definition";
    public static final String SORTABLE_FIELD_ANNOTATION = "SortableField";
    public static final String SORTABLE_FIELDS_ANNOTATION = "SortableFields";
    public static final IndexingMetadata NO_INDEXING = new IndexingMetadata(false, null, null, null);
    private final boolean isIndexed;
    private final String indexName;
    private final String analyzer;
    private final Map<String, FieldMapping> fields;
    private final Set<String> sortableFields;

    IndexingMetadata(boolean isIndexed, String indexName, String analyzer, Map<String, FieldMapping> fields) {
        this.isIndexed = isIndexed;
        this.indexName = indexName;
        this.analyzer = analyzer;
        this.fields = fields;
        this.sortableFields = fields == null ? Collections.emptySet() : fields.values().stream().filter(FieldMapping::sortable).map(FieldMapping::name).collect(Collectors.toSet());
    }

    public boolean isIndexed() {
        return this.isIndexed;
    }

    public String indexName() {
        return this.indexName;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public boolean isFieldIndexed(String fieldName) {
        if (this.fields == null) {
            return this.isIndexed;
        }
        FieldMapping fieldMapping = this.fields.get(fieldName);
        return fieldMapping != null && fieldMapping.index();
    }

    public boolean isFieldAnalyzed(String fieldName) {
        if (this.fields == null) {
            return false;
        }
        FieldMapping fieldMapping = this.fields.get(fieldName);
        return fieldMapping != null && fieldMapping.analyze();
    }

    public boolean isFieldStored(String fieldName) {
        if (this.fields == null) {
            return this.isIndexed;
        }
        FieldMapping fieldMapping = this.fields.get(fieldName);
        return fieldMapping != null && fieldMapping.store();
    }

    public Object getNullMarker(String fieldName) {
        if (this.fields == null) {
            return null;
        }
        FieldMapping fieldMapping = this.fields.get(fieldName);
        return fieldMapping != null ? fieldMapping.indexNullAs() : null;
    }

    public FieldMapping getFieldMapping(String name) {
        return this.fields.get(name);
    }

    public Set<String> getSortableFields() {
        return this.sortableFields;
    }

    public String toString() {
        return "IndexingMetadata{isIndexed=" + this.isIndexed + ", indexName='" + this.indexName + '\'' + ", analyzer='" + this.analyzer + '\'' + ", fields=" + this.fields + ", sortableFields=" + this.sortableFields + '}';
    }

    public static void configure(Configuration.Builder builder) {
        builder.annotationsConfig().annotation(INDEXED_ANNOTATION, new AnnotationElement.AnnotationTarget[]{AnnotationElement.AnnotationTarget.MESSAGE}).attribute("value").type(AnnotationElement.AttributeType.BOOLEAN).defaultValue((Object)true).attribute("index").type(AnnotationElement.AttributeType.STRING).defaultValue((Object)"").metadataCreator((AnnotationMetadataCreator)new IndexingMetadataCreator()).parentBuilder().annotation(ANALYZER_ANNOTATION, new AnnotationElement.AnnotationTarget[]{AnnotationElement.AnnotationTarget.MESSAGE, AnnotationElement.AnnotationTarget.FIELD}).attribute(ANALYZER_DEFINITION_ATTRIBUTE).type(AnnotationElement.AttributeType.STRING).defaultValue((Object)"").parentBuilder().annotation(INDEXED_FIELD_ANNOTATION, new AnnotationElement.AnnotationTarget[]{AnnotationElement.AnnotationTarget.FIELD}).attribute("index").type(AnnotationElement.AttributeType.BOOLEAN).defaultValue((Object)true).attribute("store").type(AnnotationElement.AttributeType.BOOLEAN).defaultValue((Object)true).parentBuilder().annotation(FIELD_ANNOTATION, new AnnotationElement.AnnotationTarget[]{AnnotationElement.AnnotationTarget.FIELD}).repeatable(FIELDS_ANNOTATION).attribute(FIELD_NAME_ATTRIBUTE).type(AnnotationElement.AttributeType.STRING).defaultValue((Object)"").attribute("index").type(AnnotationElement.AttributeType.IDENTIFIER).allowedValues(new String[]{INDEX_YES, INDEX_NO}).defaultValue((Object)INDEX_YES).attribute(FIELD_BOOST_ATTRIBUTE).type(AnnotationElement.AttributeType.FLOAT).defaultValue((Object)Float.valueOf(1.0f)).attribute(FIELD_ANALYZE_ATTRIBUTE).type(AnnotationElement.AttributeType.IDENTIFIER).allowedValues(new String[]{ANALYZE_YES, ANALYZE_NO}).defaultValue((Object)ANALYZE_NO).attribute("store").type(AnnotationElement.AttributeType.IDENTIFIER).allowedValues(new String[]{STORE_YES, STORE_NO}).defaultValue((Object)STORE_NO).attribute(FIELD_ANALYZER_ATTRIBUTE).type(AnnotationElement.AttributeType.ANNOTATION).allowedValues(new String[]{ANALYZER_ANNOTATION}).defaultValue((Object)"@Analyzer(definition=\"\")").attribute(FIELD_INDEX_NULL_AS_ATTRIBUTE).type(AnnotationElement.AttributeType.STRING).defaultValue((Object)DO_NOT_INDEX_NULL).parentBuilder().annotation(SORTABLE_FIELD_ANNOTATION, new AnnotationElement.AnnotationTarget[]{AnnotationElement.AnnotationTarget.FIELD}).repeatable(SORTABLE_FIELDS_ANNOTATION);
    }

    public static boolean isLegacyIndexingEnabled(Descriptor messageDescriptor) {
        boolean isLegacyIndexingEnabled = true;
        for (Option o : messageDescriptor.getFileDescriptor().getOptions()) {
            if (!o.getName().equals(INDEXED_BY_DEFAULT_OPTION)) continue;
            isLegacyIndexingEnabled = Boolean.valueOf((String)o.getValue());
            break;
        }
        return isLegacyIndexingEnabled;
    }
}

