/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.filter;

import java.io.IOException;
import org.infinispan.Cache;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.notifications.cachelistener.filter.IndexedFilter;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.dsl.embedded.impl.IckleFilterIndexingServiceProvider;
import org.infinispan.query.remote.client.FilterResult;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.filter.IckleProtobufCacheEventFilterConverter;

public final class IckleProtobufFilterIndexingServiceProvider
extends IckleFilterIndexingServiceProvider {
    private SerializationContext serCtx;
    private boolean isCompatMode;

    @Inject
    protected void injectDependencies(Cache cache) {
        this.serCtx = ProtobufMetadataManagerImpl.getSerializationContextInternal(cache.getCacheManager());
        this.isCompatMode = cache.getCacheConfiguration().compatibility().enabled();
    }

    public boolean supportsFilter(IndexedFilter<?, ?, ?> indexedFilter) {
        return indexedFilter.getClass() == IckleProtobufCacheEventFilterConverter.class;
    }

    protected Object makeFilterResult(Object userContext, Object eventType, Object key, Object instance, Object[] projection, Comparable[] sortProjection) {
        Object result = new FilterResult(instance, projection, sortProjection);
        if (!this.isCompatMode) {
            try {
                result = ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)this.serCtx, (Object)result);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

