/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.Security;

final class SecurityActions {
    private SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return (T)(System.getSecurityManager() != null ? AccessController.doPrivileged(action) : Security.doPrivileged(action));
    }

    static ComponentRegistry getCacheComponentRegistry(AdvancedCache<?, ?> cache) {
        return SecurityActions.doPrivileged(() -> cache.getComponentRegistry());
    }

    static Configuration getCacheConfiguration(AdvancedCache<?, ?> cache) {
        return SecurityActions.doPrivileged(() -> cache.getCacheConfiguration());
    }

    static AuthorizationManager getCacheAuthorizationManager(AdvancedCache<?, ?> cache) {
        return SecurityActions.doPrivileged(() -> cache.getAuthorizationManager());
    }
}

