/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.spi.CustomTypeMetadata;
import org.infinispan.AdvancedCache;
import org.infinispan.objectfilter.impl.ProtobufMatcher;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.dsl.embedded.impl.IckleFilterAndConverter;
import org.infinispan.query.dsl.embedded.impl.RowProcessor;
import org.infinispan.query.impl.SearchManagerImpl;
import org.infinispan.query.remote.impl.BaseRemoteQueryEngine;
import org.infinispan.query.remote.impl.ProtobufFieldBridgeAndAnalyzerProvider;
import org.infinispan.query.remote.impl.filter.IckleProtobufFilterAndConverter;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;

final class RemoteQueryEngine
extends BaseRemoteQueryEngine {
    RemoteQueryEngine(AdvancedCache<?, ?> cache, boolean isIndexed) {
        super(cache, isIndexed, ProtobufMatcher.class, new ProtobufFieldBridgeAndAnalyzerProvider());
    }

    protected RowProcessor makeProjectionProcessor(Class<?>[] projectedTypes) {
        int[] pos = new int[projectedTypes.length];
        int len = 0;
        for (int i = 0; i < projectedTypes.length; ++i) {
            if (projectedTypes[i] != Boolean.class) continue;
            pos[len++] = i;
        }
        if (len == 0) {
            return null;
        }
        int[] cols = len < pos.length ? Arrays.copyOf(pos, len) : pos;
        return row -> {
            for (int i : cols) {
                if (row[i] == null) continue;
                row[i] = "true".equals(row[i]);
            }
            return row;
        };
    }

    protected Query makeTypeQuery(Query query, String targetEntityName) {
        return new BooleanQuery.Builder().add((Query)new TermQuery(new Term("$type$", targetEntityName)), BooleanClause.Occur.FILTER).add(query, BooleanClause.Occur.MUST).build();
    }

    protected CacheQuery<?> makeCacheQuery(final IckleParsingResult<Descriptor> ickleParsingResult, Query luceneQuery) {
        CustomTypeMetadata customTypeMetadata = new CustomTypeMetadata(){

            public Class<?> getEntityType() {
                return ProtobufValueWrapper.class;
            }

            public Set<String> getSortableFields() {
                IndexingMetadata indexingMetadata = (IndexingMetadata)((Descriptor)ickleParsingResult.getTargetEntityMetadata()).getProcessedAnnotation("Indexed");
                return indexingMetadata != null ? indexingMetadata.getSortableFields() : Collections.emptySet();
            }
        };
        HSQuery hSearchQuery = this.getSearchFactory().createHSQuery(luceneQuery, new CustomTypeMetadata[]{customTypeMetadata});
        return ((SearchManagerImpl)this.getSearchManager()).getQuery(hSearchQuery);
    }

    protected IckleFilterAndConverter createFilter(String queryString, Map<String, Object> namedParameters) {
        return this.isIndexed ? new IckleProtobufFilterAndConverter(queryString, namedParameters) : super.createFilter(queryString, namedParameters);
    }

    protected Class<?> getTargetedClass(IckleParsingResult<?> parsingResult) {
        return ProtobufValueWrapper.class;
    }
}

