/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.compat.PassThroughTypeConverter;
import org.infinispan.compat.TypeConverter;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.compat.BaseTypeConverterInterceptor;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;

public final class RemoteValueWrapperInterceptor<K, V>
extends BaseTypeConverterInterceptor<K, V> {
    private final ProtobufValueWrapperTypeConverter protobufTypeConverter = new ProtobufValueWrapperTypeConverter();
    private final PassThroughTypeConverter passThroughTypeConverter = new PassThroughTypeConverter();

    @Inject
    public void injectDependencies(CacheNotifier cacheNotifier) {
        cacheNotifier.setTypeConverter((TypeConverter)this.protobufTypeConverter);
    }

    protected TypeConverter<Object, Object, Object, Object> determineTypeConverter(FlagAffectedCommand command) {
        return command.hasAnyFlag(FlagBitSets.OPERATION_HOTROD) ? this.protobufTypeConverter : this.passThroughTypeConverter;
    }

    private class ProtobufValueWrapperTypeConverter
    extends PassThroughTypeConverter {
        private ProtobufValueWrapperTypeConverter() {
        }

        public Object boxValue(Object value) {
            if (value instanceof WrappedByteArray) {
                return new ProtobufValueWrapper(((WrappedByteArray)value).getBytes());
            }
            return value;
        }

        public Object unboxValue(Object target) {
            if (target instanceof ProtobufValueWrapper) {
                byte[] bytes = ((ProtobufValueWrapper)target).getBinary();
                return new WrappedByteArray(bytes);
            }
            return target;
        }
    }
}

