/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.protostream.ProtobufParser;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.impl.indexing.WrappedMessageTagHandler;

public final class ProtobufValueWrapperFieldBridge
implements FieldBridge {
    private final Cache cache;
    private SerializationContext serializationContext = null;
    private Descriptor wrapperDescriptor = null;

    public ProtobufValueWrapperFieldBridge(Cache cache) {
        this.cache = cache;
    }

    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (!(value instanceof ProtobufValueWrapper)) {
            throw new IllegalArgumentException("This FieldBridge can only be applied to a ProtobufValueWrapper");
        }
        ProtobufValueWrapper valueWrapper = (ProtobufValueWrapper)value;
        this.decodeAndIndex(valueWrapper.getBinary(), document, luceneOptions);
    }

    private void decodeAndIndex(byte[] bytes, Document document, LuceneOptions luceneOptions) {
        if (this.serializationContext == null) {
            this.serializationContext = ProtobufMetadataManagerImpl.getSerializationContextInternal(this.cache.getCacheManager());
        }
        if (this.wrapperDescriptor == null) {
            this.wrapperDescriptor = this.serializationContext.getMessageDescriptor("org.infinispan.protostream.WrappedMessage");
        }
        try {
            ProtobufParser.INSTANCE.parse((TagHandler)new WrappedMessageTagHandler(document, luceneOptions, this.serializationContext), this.wrapperDescriptor, bytes);
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }
}

