/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import java.util.HashSet;
import org.infinispan.protostream.AnnotationMetadataCreator;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;

public final class IndexingMetadataCreator
implements AnnotationMetadataCreator<IndexingMetadata, Descriptor> {
    public IndexingMetadata create(Descriptor descriptor, AnnotationElement.Annotation annotation) {
        AnnotationElement.Value indexedValue = annotation.getDefaultAttributeValue();
        if (Boolean.TRUE.equals(indexedValue.getValue())) {
            HashSet<Integer> indexedFields = new HashSet<Integer>();
            HashSet<Integer> storedFields = new HashSet<Integer>();
            for (FieldDescriptor fd : descriptor.getFields()) {
                AnnotationElement.Value storeAttribute;
                AnnotationElement.Annotation indexedFieldAnnotation = (AnnotationElement.Annotation)fd.getAnnotations().get("IndexedField");
                if (indexedFieldAnnotation == null) continue;
                AnnotationElement.Value indexAttribute = indexedFieldAnnotation.getAttributeValue("index");
                if (Boolean.TRUE.equals(indexAttribute.getValue())) {
                    indexedFields.add(fd.getNumber());
                }
                if (!Boolean.TRUE.equals((storeAttribute = indexedFieldAnnotation.getAttributeValue("store")).getValue())) continue;
                storedFields.add(fd.getNumber());
            }
            return new IndexingMetadata(true, indexedFields, storedFields);
        }
        return new IndexingMetadata(false, null, null);
    }
}

