/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.query.remote.RemoteQueryEngine;
import org.infinispan.query.remote.SecurityActions;
import org.infinispan.query.remote.client.QueryRequest;
import org.infinispan.query.remote.client.QueryResponse;
import org.infinispan.query.remote.logging.Log;
import org.infinispan.server.core.QueryFacade;

public final class QueryFacadeImpl
implements QueryFacade {
    private static final Log log = (Log)LogFactory.getLog(QueryFacadeImpl.class, Log.class);
    public static final String TYPE_FIELD_NAME = "$type$";
    public static final String NULL_TOKEN = "_null_";

    public byte[] query(AdvancedCache<byte[], byte[]> cache, byte[] query) {
        try {
            SerializationContext serCtx = ProtobufMetadataManager.getSerializationContextInternal(cache.getCacheManager());
            QueryRequest request = (QueryRequest)ProtobufUtil.fromByteArray((SerializationContext)serCtx, (byte[])query, (int)0, (int)query.length, QueryRequest.class);
            Configuration cacheConfiguration = SecurityActions.getCacheConfiguration(cache);
            boolean isIndexed = cacheConfiguration.indexing().index().isEnabled();
            boolean isCompatMode = cacheConfiguration.compatibility().enabled();
            SearchManager searchManager = isIndexed ? Search.getSearchManager(cache) : null;
            Query q = new RemoteQueryEngine(cache, searchManager, isCompatMode, serCtx).buildQuery(null, request.getJpqlString(), request.getStartOffset(), request.getMaxResults());
            QueryResponse response = this.makeResponse(q);
            return ProtobufUtil.toByteArray((SerializationContext)serCtx, (Object)response);
        }
        catch (IOException e) {
            throw log.errorExecutingQuery(e);
        }
    }

    private QueryResponse makeResponse(Query q) {
        List list = q.list();
        int numResults = list.size();
        String[] projection = ((BaseQuery)q).getProjection();
        int projSize = projection != null ? projection.length : 0;
        ArrayList<WrappedMessage> results = new ArrayList<WrappedMessage>(projSize == 0 ? numResults : numResults * projSize);
        for (Object o : list) {
            if (projSize == 0) {
                results.add(new WrappedMessage(o));
                continue;
            }
            Object[] row = (Object[])o;
            for (int j = 0; j < projSize; ++j) {
                results.add(new WrappedMessage(row[j]));
            }
        }
        QueryResponse response = new QueryResponse();
        response.setTotalResults((long)q.getResultSize());
        response.setNumResults(numResults);
        response.setProjectionSize(projSize);
        response.setResults(results);
        return response;
    }
}

