/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote;

import java.io.IOException;
import java.nio.file.Paths;
import javax.management.MBeanException;
import javax.management.ObjectName;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.ProtobufMetadataManagerMBean;
import org.infinispan.query.remote.logging.Log;
import org.infinispan.registry.ClusterRegistry;
import org.infinispan.registry.ScopedKey;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
@MBean(objectName="ProtobufMetadataManager", description="Component that acts as a manager and container for Protocol Buffers metadata descriptors in the scope of a CacheManger.")
public class ProtobufMetadataManager
implements ProtobufMetadataManagerMBean {
    private static final Log log = (Log)LogFactory.getLog(ProtobufMetadataManager.class, Log.class);
    public static final String OBJECT_NAME = "ProtobufMetadataManager";
    private static final String REGISTRY_SCOPE = ProtobufMetadataManager.class.getName();
    private static final String REGISTRY_KEY = "_descriptors";
    private ObjectName objectName;
    private ClusterRegistry<String, String, FileDescriptorSource> clusterRegistry;
    private volatile ProtobufMetadataRegistryListener registryListener;
    private final SerializationContext serCtx;

    public ProtobufMetadataManager(SerializationContext serCtx) {
        this.serCtx = serCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInit() {
        if (this.registryListener == null) {
            ProtobufMetadataManager protobufMetadataManager = this;
            synchronized (protobufMetadataManager) {
                if (this.registryListener == null) {
                    this.registryListener = new ProtobufMetadataRegistryListener();
                    this.clusterRegistry.addListener((Object)REGISTRY_SCOPE, (Object)this.registryListener);
                    FileDescriptorSource descriptorSource = this.getFileDescriptorSource();
                    if (!descriptorSource.getFileDescriptors().isEmpty()) {
                        try {
                            this.serCtx.registerProtoFiles(descriptorSource);
                        }
                        catch (Exception e) {
                            log.error(e);
                        }
                    }
                }
            }
        }
    }

    @Inject
    protected void injectDependencies(ClusterRegistry<String, String, FileDescriptorSource> clusterRegistry) {
        this.clusterRegistry = clusterRegistry;
    }

    @Stop
    protected void stop() {
        if (this.registryListener != null) {
            this.clusterRegistry.removeListener((Object)this.registryListener);
            this.registryListener = null;
        }
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public <T> void registerMarshaller(BaseMarshaller<T> marshaller) {
        this.ensureInit();
        this.serCtx.registerMarshaller(marshaller);
    }

    @Override
    @ManagedOperation(description="Registers a set of Protobuf definition files", displayName="Register Protofiles")
    public void registerProtofiles(@Parameter(name="fileNames", description="names of the protofiles") String[] names, @Parameter(name="fileContents", description="content of the files") String[] contents) throws Exception {
        if (names.length != contents.length) {
            throw new MBeanException(new IllegalArgumentException("invalid parameter sizes"));
        }
        FileDescriptorSource fileDescriptorSource = this.getFileDescriptorSource();
        for (int i = 0; i < names.length; ++i) {
            fileDescriptorSource.addProtoFile(names[i], contents[i]);
        }
        this.clusterRegistry.put((Object)REGISTRY_SCOPE, (Object)REGISTRY_KEY, (Object)fileDescriptorSource);
    }

    @Override
    @ManagedOperation(description="Registers a Protobuf definition file", displayName="Register Protofile")
    public void registerProtofile(@Parameter(name="fileName", description="the name of the .proto file") String name, @Parameter(name="contents", description="contents of the file") String contents) throws Exception {
        FileDescriptorSource fileDescriptorSource = this.getFileDescriptorSource();
        fileDescriptorSource.addProtoFile(name, contents);
        this.clusterRegistry.put((Object)REGISTRY_SCOPE, (Object)REGISTRY_KEY, (Object)fileDescriptorSource);
    }

    @Override
    @ManagedOperation(description="Display a protobuf definition file", displayName="Register Protofile")
    public String displayProtofile(@Parameter(name="fileName", description="the name of the .proto file") String name) {
        FileDescriptorSource fileDescriptorSource = (FileDescriptorSource)this.clusterRegistry.get((Object)REGISTRY_SCOPE, (Object)REGISTRY_KEY);
        if (fileDescriptorSource == null) {
            return null;
        }
        char[] data = (char[])fileDescriptorSource.getFileDescriptors().get(name);
        return data != null ? String.valueOf(data) : null;
    }

    public void registerProtofiles(String ... classPathResources) throws Exception {
        FileDescriptorSource fileDescriptorSource = this.getFileDescriptorSource();
        for (String classPathResource : classPathResources) {
            String fileName = Paths.get(classPathResource, new String[0]).getFileName().toString();
            fileDescriptorSource.addProtoFile(fileName, Util.getResourceAsStream((String)classPathResource, (ClassLoader)this.getClass().getClassLoader()));
        }
        this.clusterRegistry.put((Object)REGISTRY_SCOPE, (Object)REGISTRY_KEY, (Object)fileDescriptorSource);
    }

    public static SerializationContext getSerializationContext(EmbeddedCacheManager cacheManager) {
        if (cacheManager == null) {
            throw new IllegalArgumentException("cacheManager cannot be null");
        }
        ProtobufMetadataManager metadataManager = (ProtobufMetadataManager)cacheManager.getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
        if (metadataManager == null) {
            throw new IllegalStateException("ProtobufMetadataManager not initialised yet!");
        }
        metadataManager.ensureInit();
        return metadataManager.serCtx;
    }

    private FileDescriptorSource getFileDescriptorSource() {
        FileDescriptorSource fileDescriptorSource = (FileDescriptorSource)this.clusterRegistry.get((Object)REGISTRY_SCOPE, (Object)REGISTRY_KEY);
        if (fileDescriptorSource == null) {
            fileDescriptorSource = new FileDescriptorSource();
        }
        return fileDescriptorSource;
    }

    @Listener
    class ProtobufMetadataRegistryListener {
        ProtobufMetadataRegistryListener() {
        }

        @CacheEntryCreated
        public void created(CacheEntryCreatedEvent<ScopedKey<String, String>, FileDescriptorSource> e) throws IOException {
            if (!e.isPre()) {
                this.registerProtofile((FileDescriptorSource)e.getValue());
            }
        }

        private void registerProtofile(FileDescriptorSource value) throws IOException {
            ProtobufMetadataManager.this.serCtx.registerProtoFiles(value);
        }

        @CacheEntryModified
        public void modified(CacheEntryModifiedEvent<ScopedKey<String, String>, FileDescriptorSource> e) throws IOException {
            if (!e.isPre()) {
                this.registerProtofile((FileDescriptorSource)e.getValue());
            }
        }
    }
}

