/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.search;

import com.google.protobuf.Descriptors;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.AstProcessor;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.hql.ast.spi.QueryRendererDelegate;
import org.hibernate.hql.ast.spi.QueryRendererProcessor;
import org.hibernate.hql.ast.spi.QueryResolverDelegate;
import org.hibernate.hql.ast.spi.QueryResolverProcessor;
import org.hibernate.hql.ast.spi.SingleEntityQueryBuilder;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.hibernate.hql.lucene.LuceneQueryParsingResult;
import org.hibernate.hql.lucene.internal.LuceneQueryRendererDelegate;
import org.hibernate.hql.lucene.internal.builder.LucenePropertyHelper;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.search.IspnLucenePredicateFactory;
import org.infinispan.query.remote.search.IspnLuceneQueryParsingResult;
import org.infinispan.query.remote.search.IspnLuceneQueryResolverDelegate;

public class IspnLuceneProcessingChain
implements AstProcessingChain<IspnLuceneQueryParsingResult> {
    private static final Integer TRUE_INT = 1;
    private static final Integer FALSE_INT = 0;
    private final QueryResolverProcessor resolverProcessor;
    private final QueryRendererProcessor rendererProcessor;
    private final LuceneQueryRendererDelegate rendererDelegate;
    private final IspnLuceneQueryResolverDelegate queryResolverDelegate;

    public IspnLuceneProcessingChain(SerializationContext serializationContext, SearchFactoryIntegrator searchFactory, EntityNamesResolver entityNames, Map<String, Object> namedParameters) {
        this.queryResolverDelegate = new IspnLuceneQueryResolverDelegate(serializationContext);
        this.resolverProcessor = new QueryResolverProcessor((QueryResolverDelegate)this.queryResolverDelegate);
        LucenePropertyHelper propertyHelper = new LucenePropertyHelper(searchFactory){

            public Object convertToPropertyType(String value, Class<?> entityType, String ... propertyPath) {
                Descriptors.FieldDescriptor field = IspnLuceneProcessingChain.this.queryResolverDelegate.getTargetType().findFieldByName(propertyPath[propertyPath.length - 1]);
                if (field != null) {
                    switch (field.getJavaType()) {
                        case INT: {
                            return Integer.parseInt(value);
                        }
                        case LONG: {
                            return Long.parseLong(value);
                        }
                        case FLOAT: {
                            return Float.valueOf(Float.parseFloat(value));
                        }
                        case DOUBLE: {
                            return Double.parseDouble(value);
                        }
                        case BOOLEAN: {
                            return Boolean.valueOf(value) != false ? TRUE_INT : FALSE_INT;
                        }
                        case ENUM: {
                            return field.getEnumType().findValueByName(value).getNumber();
                        }
                    }
                }
                return value;
            }
        };
        SingleEntityQueryBuilder queryBuilder = SingleEntityQueryBuilder.getInstance((PredicateFactory)new IspnLucenePredicateFactory(searchFactory.buildQueryBuilder(), propertyHelper), (PropertyHelper)propertyHelper);
        this.rendererDelegate = new LuceneQueryRendererDelegate(entityNames, queryBuilder, namedParameters);
        this.rendererProcessor = new QueryRendererProcessor((QueryRendererDelegate)this.rendererDelegate);
    }

    public Iterator<AstProcessor> iterator() {
        return Arrays.asList(this.resolverProcessor, this.rendererProcessor).iterator();
    }

    public IspnLuceneQueryParsingResult getResult() {
        LuceneQueryParsingResult result = this.rendererDelegate.getResult();
        return new IspnLuceneQueryParsingResult(result.getQuery(), this.queryResolverDelegate.getTargetType(), result.getTargetEntity(), result.getProjections());
    }
}

