/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.search;

import com.google.protobuf.Descriptors;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.hibernate.hql.ast.TypeDescriptor;
import org.hibernate.hql.ast.common.JoinType;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReference;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.QueryResolverDelegate;
import org.hibernate.hql.lucene.internal.ast.HSearchEmbeddedEntityTypeDescriptor;
import org.hibernate.hql.lucene.internal.ast.HSearchPropertyTypeDescriptor;
import org.hibernate.hql.lucene.internal.ast.HSearchTypeDescriptor;
import org.hibernate.hql.lucene.internal.logging.Log;
import org.hibernate.hql.lucene.internal.logging.LoggerFactory;
import org.infinispan.query.remote.SerializationContextHolder;
import org.infinispan.query.remote.search.ProtobufValueWrapperTypeDescriptor;

class IspnLuceneQueryResolverDelegate
implements QueryResolverDelegate {
    private static final Log log = LoggerFactory.make();
    private final Map<String, String> aliasToEntityType = new HashMap<String, String>();
    private Status status;
    private Descriptors.Descriptor targetType;

    Descriptors.Descriptor getTargetType() {
        return this.targetType;
    }

    public void registerPersisterSpace(Tree entityName, Tree alias) {
        String put = this.aliasToEntityType.put(alias.getText(), entityName.getText());
        if (put != null && !put.equalsIgnoreCase(entityName.getText())) {
            throw new UnsupportedOperationException("Alias reuse currently not supported: alias " + alias.getText() + " already assigned to type " + put);
        }
        Descriptors.Descriptor targetedType = SerializationContextHolder.getSerializationContext().getMessageDescriptor(entityName.getText());
        if (this.targetType != null) {
            throw new IllegalStateException("Can't target multiple types: " + this.targetType + " already selected before " + targetedType);
        }
        this.targetType = targetedType;
    }

    public boolean isUnqualifiedPropertyReference() {
        return true;
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedPropertyReference(Tree property) {
        if (this.aliasToEntityType.containsKey(property.getText())) {
            return this.normalizeQualifiedRoot(property);
        }
        return this.normalizeProperty(new ProtobufValueWrapperTypeDescriptor(this.targetType), Collections.<String>emptyList(), property.getText());
    }

    public boolean isPersisterReferenceAlias() {
        if (this.aliasToEntityType.size() == 1) {
            return true;
        }
        throw new UnsupportedOperationException("Unexpected use case: not implemented yet?");
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedRoot(Tree identifier382) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public PathedPropertyReferenceSource normalizeQualifiedRoot(Tree root) {
        String entityNameForAlias = this.aliasToEntityType.get(root.getText());
        if (entityNameForAlias == null) {
            throw log.getUnknownAliasException(root.getText());
        }
        Descriptors.Descriptor descriptor = SerializationContextHolder.getSerializationContext().getMessageDescriptor(entityNameForAlias);
        return new PathedPropertyReference(root.getText(), (TypeDescriptor)new ProtobufValueWrapperTypeDescriptor(descriptor), true);
    }

    public PathedPropertyReferenceSource normalizePropertyPathIntermediary(PropertyPath path, Tree propertyName) {
        ProtobufValueWrapperTypeDescriptor sourceType = (ProtobufValueWrapperTypeDescriptor)path.getLastNode().getType();
        if (!sourceType.hasProperty(propertyName.getText())) {
            throw log.getNoSuchPropertyException(sourceType.toString(), propertyName.getText());
        }
        Descriptors.Descriptor descriptor = sourceType.getMessageDescriptor().findFieldByName(propertyName.getText()).getMessageType();
        PathedPropertyReference property = new PathedPropertyReference(propertyName.getText(), (TypeDescriptor)new ProtobufValueWrapperTypeDescriptor(descriptor), false);
        return property;
    }

    public PathedPropertyReferenceSource normalizeIntermediateIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void normalizeTerminalIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedPropertyReferenceSource(Tree identifier394) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public PathedPropertyReferenceSource normalizePropertyPathTerminus(PropertyPath path, Tree propertyNameNode) {
        return this.normalizeProperty((HSearchTypeDescriptor)path.getLastNode().getType(), path.getNodeNamesWithoutAlias(), propertyNameNode.getText());
    }

    private PathedPropertyReferenceSource normalizeProperty(HSearchTypeDescriptor type, List<String> path, String propertyName) {
        if (!type.hasProperty(propertyName)) {
            throw log.getNoSuchPropertyException(type.toString(), propertyName);
        }
        if (this.status != Status.DEFINING_SELECT && !type.isEmbedded(propertyName) && type.isAnalyzed(propertyName)) {
            throw log.getQueryOnAnalyzedPropertyNotSupportedException(type.getIndexedEntityType().getCanonicalName(), propertyName);
        }
        if (type.isEmbedded(propertyName)) {
            ProtobufValueWrapperTypeDescriptor sourceType = (ProtobufValueWrapperTypeDescriptor)type;
            Descriptors.Descriptor descriptor = sourceType.getMessageDescriptor().findFieldByName(propertyName).getMessageType();
            return new PathedPropertyReference(propertyName, (TypeDescriptor)new ProtobufValueWrapperTypeDescriptor(descriptor), false);
        }
        return new PathedPropertyReference(propertyName, (TypeDescriptor)new HSearchPropertyTypeDescriptor(), false);
    }

    public void pushFromStrategy(JoinType joinType, Tree assosiationFetchTree, Tree propertyFetchTree, Tree alias) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void pushSelectStrategy() {
        this.status = Status.DEFINING_SELECT;
    }

    public void popStrategy() {
        this.status = null;
    }

    public void propertyPathCompleted(PropertyPath path) {
        if (this.status == Status.DEFINING_SELECT && path.getLastNode().getType() instanceof HSearchEmbeddedEntityTypeDescriptor) {
            HSearchEmbeddedEntityTypeDescriptor type = (HSearchEmbeddedEntityTypeDescriptor)path.getLastNode().getType();
            throw log.getProjectionOfCompleteEmbeddedEntitiesNotSupportedException(type.getIndexedEntityType().getCanonicalName(), path.asStringPathWithoutAlias());
        }
    }

    private static enum Status {
        DEFINING_SELECT,
        DEFINING_FROM;

    }
}

