/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.search;

import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.ast.spi.predicate.ConjunctionPredicate;
import org.hibernate.hql.ast.spi.predicate.DisjunctionPredicate;
import org.hibernate.hql.ast.spi.predicate.InPredicate;
import org.hibernate.hql.ast.spi.predicate.IsNullPredicate;
import org.hibernate.hql.ast.spi.predicate.LikePredicate;
import org.hibernate.hql.ast.spi.predicate.NegationPredicate;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.hibernate.hql.ast.spi.predicate.RangePredicate;
import org.hibernate.hql.ast.spi.predicate.RootPredicate;
import org.hibernate.hql.internal.util.Strings;
import org.hibernate.hql.lucene.internal.builder.LucenePropertyHelper;
import org.hibernate.hql.lucene.internal.builder.predicate.LuceneConjunctionPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.LuceneDisjunctionPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.LuceneNegationPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.LuceneRootPredicate;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.QueryContextBuilder;
import org.infinispan.query.remote.search.IspnLuceneComparisonPredicate;
import org.infinispan.query.remote.search.IspnLuceneInPredicate;
import org.infinispan.query.remote.search.IspnLuceneIsNullPredicate;
import org.infinispan.query.remote.search.IspnLuceneLikePredicate;
import org.infinispan.query.remote.search.IspnLuceneRangePredicate;

class IspnLucenePredicateFactory
implements PredicateFactory<Query> {
    private final QueryContextBuilder queryContextBuilder;
    private final LucenePropertyHelper propertyHelper;
    private QueryBuilder queryBuilder;

    public IspnLucenePredicateFactory(QueryContextBuilder queryContextBuilder, LucenePropertyHelper propertyHelper) {
        this.queryContextBuilder = queryContextBuilder;
        this.propertyHelper = propertyHelper;
    }

    public RootPredicate<Query> getRootPredicate(Class<?> entityType) {
        this.queryBuilder = this.queryContextBuilder.forEntity(entityType).get();
        return new LuceneRootPredicate(this.queryBuilder);
    }

    public ComparisonPredicate<Query> getComparisonPredicate(Class<?> entityType, ComparisonPredicate.Type comparisonType, List<String> propertyPath, Object value) {
        return new IspnLuceneComparisonPredicate(this.queryBuilder, Strings.join(propertyPath, (String)"."), comparisonType, value);
    }

    public InPredicate<Query> getInPredicate(Class<?> entityType, List<String> propertyPath, List<Object> values) {
        return new IspnLuceneInPredicate(this.queryBuilder, Strings.join(propertyPath, (String)"."), values);
    }

    public RangePredicate<Query> getRangePredicate(Class<?> entityType, List<String> propertyPath, Object lowerValue, Object upperValue) {
        return new IspnLuceneRangePredicate(this.queryBuilder, Strings.join(propertyPath, (String)"."), lowerValue, upperValue);
    }

    public NegationPredicate<Query> getNegationPredicate() {
        return new LuceneNegationPredicate(this.queryBuilder);
    }

    public DisjunctionPredicate<Query> getDisjunctionPredicate() {
        return new LuceneDisjunctionPredicate(this.queryBuilder);
    }

    public ConjunctionPredicate<Query> getConjunctionPredicate() {
        return new LuceneConjunctionPredicate(this.queryBuilder);
    }

    public LikePredicate<Query> getLikePredicate(Class<?> entityType, List<String> propertyPath, String patternValue, Character escapeCharacter) {
        return new IspnLuceneLikePredicate(this.queryBuilder, Strings.join(propertyPath, (String)"."), patternValue);
    }

    public IsNullPredicate<Query> getIsNullPredicate(Class<?> entityType, List<String> propertyPath) {
        TypeMetadata typeMetadata = this.propertyHelper.getLeafTypeMetadata(entityType, propertyPath.toArray(new String[propertyPath.size()]));
        return new IspnLuceneIsNullPredicate(this.queryBuilder, Strings.join(propertyPath, (String)"."), "_null_");
    }

    public static boolean isNumericValue(Object value) {
        if (value != null) {
            Class<Number> numericClass = value.getClass();
            return numericClass.isAssignableFrom(Double.class) || numericClass.isAssignableFrom(Long.class) || numericClass.isAssignableFrom(Integer.class) || numericClass.isAssignableFrom(Float.class);
        }
        return false;
    }
}

