/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.indexing;

import com.google.protobuf.Descriptors;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.engine.impl.LuceneOptionsImpl;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.infinispan.protostream.TagHandler;
import org.infinispan.query.remote.indexing.MessageContext;

class IndexingTagHandler
implements TagHandler {
    private static final Integer TRUE_INT = 1;
    private static final Integer FALSE_INT = 0;
    private static final LuceneOptions STORED_NOT_ANALYZED = new LuceneOptionsImpl(new DocumentFieldMetadata.Builder(null, Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.NO).boost(Float.valueOf(1.0f)).build());
    private final Document document;
    private final LuceneOptions defaultLuceneOptions;
    private String fieldPrefix = null;
    private MessageContext messageContext;

    public IndexingTagHandler(Descriptors.Descriptor messageDescriptor, Document document, LuceneOptions defaultLuceneOptions) {
        this.document = document;
        this.defaultLuceneOptions = defaultLuceneOptions;
        this.messageContext = new MessageContext(messageDescriptor);
    }

    public void onStart() {
    }

    public void onTag(int fieldNumber, String fieldName, Descriptors.FieldDescriptor.Type type, Descriptors.FieldDescriptor.JavaType javaType, Object value) {
        this.messageContext.getReadFields().add(fieldNumber);
        if (fieldName != null && this.isIndexed(fieldName)) {
            String fn = this.getFieldFullName(fieldName);
            switch (type) {
                case DOUBLE: 
                case FLOAT: 
                case INT64: 
                case UINT64: 
                case INT32: 
                case FIXED64: 
                case FIXED32: 
                case UINT32: 
                case SFIXED32: 
                case SFIXED64: 
                case SINT32: 
                case SINT64: 
                case ENUM: {
                    STORED_NOT_ANALYZED.addNumericFieldToDocument(fn, value, this.document);
                    break;
                }
                case BOOL: {
                    STORED_NOT_ANALYZED.addNumericFieldToDocument(fn, (Object)((Boolean)value != false ? TRUE_INT : FALSE_INT), this.document);
                    break;
                }
                default: {
                    this.defaultLuceneOptions.addFieldToDocument(fn, String.valueOf(value), this.document);
                }
            }
        }
    }

    private String getFieldFullName(String fieldName) {
        return this.fieldPrefix != null ? this.fieldPrefix + fieldName : fieldName;
    }

    private boolean isIndexed(String fieldName) {
        Descriptors.FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        return true;
    }

    public void onStartNested(int fieldNumber, String fieldName, Descriptors.Descriptor messageDescriptor) {
        this.messageContext.getReadFields().add(fieldNumber);
        this.pushContext(fieldName, messageDescriptor);
    }

    public void onEndNested(int fieldNumber, String fieldName, Descriptors.Descriptor messageDescriptor) {
        this.popContext();
    }

    public void onEnd() {
        this.indexMissingFieldsAsNull();
    }

    private void pushContext(String fieldName, Descriptors.Descriptor messageDescriptor) {
        this.fieldPrefix = this.fieldPrefix == null ? fieldName + "." : this.fieldPrefix + "." + fieldName + ".";
        this.messageContext = new MessageContext(fieldName, this.messageContext, messageDescriptor);
    }

    private void popContext() {
        int pos;
        assert (this.fieldPrefix != null);
        assert (pos >= 0);
        for (pos = this.fieldPrefix.length() - 2; pos > 0 && this.fieldPrefix.charAt(pos) != '.'; --pos) {
        }
        this.indexMissingFieldsAsNull();
        this.fieldPrefix = this.fieldPrefix.substring(0, pos);
        this.messageContext = this.messageContext.getParentContext();
    }

    private void indexMissingFieldsAsNull() {
        for (Descriptors.FieldDescriptor fd : this.messageContext.getMessageDescriptor().getFields()) {
            if (this.messageContext.getReadFields().contains(fd.getNumber())) continue;
            this.defaultLuceneOptions.addFieldToDocument(this.getFieldFullName(fd.getName()), "_null_", this.document);
        }
    }
}

