/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.encoding.impl.StorageConfigurationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.impl.ProtobufMatcher;
import org.infinispan.objectfilter.impl.syntax.IndexedFieldProvider;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.query.remote.impl.BaseRemoteQueryManager;
import org.infinispan.query.remote.impl.ObjectProtobufMatcher;
import org.infinispan.query.remote.impl.ProtobufFieldIndexingMetadata;
import org.infinispan.query.remote.impl.ProtobufWrapper;
import org.infinispan.query.remote.impl.QuerySerializers;
import org.infinispan.query.remote.impl.RemoteQueryEngine;

final class ProtobufRemoteQueryManager
extends BaseRemoteQueryManager {
    private final RemoteQueryEngine queryEngine;
    private final Transcoder protobufTranscoder;

    ProtobufRemoteQueryManager(AdvancedCache<?, ?> cache, ComponentRegistry cr, SerializationContext serCtx, QuerySerializers querySerializers) {
        super(cache, querySerializers, cr);
        ObjectProtobufMatcher matcher = new ObjectProtobufMatcher(serCtx, (IndexedFieldProvider<Descriptor>)((IndexedFieldProvider)ProtobufFieldIndexingMetadata::new), cache);
        cr.registerComponent((Object)matcher, ProtobufMatcher.class);
        Configuration configuration = cache.getCacheConfiguration();
        boolean isIndexed = configuration.indexing().enabled();
        boolean customStorage = configuration.encoding().valueDataType().isMediaTypeChanged();
        MediaType valueMediaType = this.getValueDataConversion().getStorageMediaType();
        boolean isProtoBuf = valueMediaType.match(MediaType.APPLICATION_PROTOSTREAM);
        if (isProtoBuf || !customStorage && isIndexed) {
            StorageConfigurationManager storageConfigurationManager = (StorageConfigurationManager)cr.getComponent(StorageConfigurationManager.class);
            storageConfigurationManager.overrideWrapper(storageConfigurationManager.getKeyWrapper(), (Wrapper)ProtobufWrapper.INSTANCE);
        }
        this.queryEngine = new RemoteQueryEngine(cache, isIndexed);
        EncoderRegistry encoderRegistry = (EncoderRegistry)cr.getGlobalComponentRegistry().getComponent(EncoderRegistry.class);
        this.protobufTranscoder = encoderRegistry.getTranscoder(MediaType.APPLICATION_PROTOSTREAM, MediaType.APPLICATION_OBJECT);
    }

    @Override
    public Class<? extends Matcher> getMatcherClass(MediaType mediaType) {
        return ProtobufMatcher.class;
    }

    @Override
    public RemoteQueryEngine getQueryEngine(AdvancedCache<?, ?> cache) {
        return this.queryEngine;
    }

    @Override
    public Object encodeFilterResult(Object filterResult) {
        return this.protobufTranscoder.transcode(filterResult, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_PROTOSTREAM);
    }
}

