/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.commons.CacheException;
import org.infinispan.protostream.ProtobufParser;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.impl.indexing.WrappedMessageTagHandler;
import org.infinispan.query.remote.impl.mapping.reference.GlobalReferenceHolder;
import org.infinispan.search.mapper.mapping.EntityConverter;

public class ProtobufEntityConverter
implements EntityConverter {
    private final SerializationContext serializationContext;
    private final Set<String> indexedMessageTypes;

    public ProtobufEntityConverter(SerializationContext serializationContext, Set<GlobalReferenceHolder.RootMessageInfo> rootMessages) {
        this.serializationContext = serializationContext;
        this.indexedMessageTypes = rootMessages.stream().map(rootMessage -> rootMessage.getFullName()).collect(Collectors.toSet());
    }

    public Class<?> targetType() {
        return ProtobufValueWrapper.class;
    }

    public Class<?> convertedType() {
        return byte[].class;
    }

    public EntityConverter.ConvertedEntity convert(Object entity) {
        ProtobufValueWrapper valueWrapper = (ProtobufValueWrapper)entity;
        WrappedMessageTagHandler tagHandler = new WrappedMessageTagHandler(valueWrapper, this.serializationContext);
        try {
            Descriptor wrapperDescriptor = this.serializationContext.getMessageDescriptor("org.infinispan.protostream.WrappedMessage");
            ProtobufParser.INSTANCE.parse((TagHandler)tagHandler, wrapperDescriptor, valueWrapper.getBinary());
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
        Descriptor messageDescriptor = valueWrapper.getMessageDescriptor();
        if (messageDescriptor == null) {
            return new ProtobufConvertedEntity(true, null, null);
        }
        String entityName = messageDescriptor.getFullName();
        boolean skip = !this.indexedMessageTypes.contains(entityName);
        byte[] messageBytes = tagHandler.getMessageBytes();
        return new ProtobufConvertedEntity(skip, entityName, messageBytes);
    }

    private class ProtobufConvertedEntity
    implements EntityConverter.ConvertedEntity {
        private final boolean skip;
        private final String entityName;
        private final byte[] value;

        public ProtobufConvertedEntity(boolean skip, String entityName, byte[] value) {
            this.skip = skip;
            this.entityName = entityName;
            this.value = value;
        }

        public boolean skip() {
            return this.skip;
        }

        public String entityName() {
            return this.entityName;
        }

        public Object value() {
            return this.value;
        }
    }
}

