/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.query.dsl.IndexedQueryMode;
import org.infinispan.query.remote.client.impl.QueryRequest;
import org.infinispan.query.remote.impl.RemoteQueryManager;
import org.infinispan.query.remote.impl.SecurityActions;
import org.infinispan.query.remote.impl.logging.Log;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.server.core.QueryFacade;

public final class QueryFacadeImpl
implements QueryFacade {
    private static final Log log = (Log)LogFactory.getLog(QueryFacadeImpl.class, Log.class);

    public byte[] query(AdvancedCache<?, ?> cache, byte[] query) {
        RemoteQueryManager remoteQueryManager;
        AuthorizationManager authorizationManager = SecurityActions.getCacheAuthorizationManager(cache);
        if (authorizationManager != null) {
            authorizationManager.checkPermission(AuthorizationPermission.BULK_READ);
        }
        if ((remoteQueryManager = SecurityActions.getRemoteQueryManager(cache)).getQueryEngine(cache) == null) {
            throw log.queryingNotEnabled(cache.getName());
        }
        try {
            MediaType requestMediaType = cache.getValueDataConversion().getRequestMediaType();
            QueryRequest request = remoteQueryManager.decodeQueryRequest(query, requestMediaType);
            int startOffset = request.getStartOffset().intValue();
            int maxResults = request.getMaxResults();
            IndexedQueryMode queryMode = request.getIndexedQueryMode() != null ? IndexedQueryMode.valueOf((String)request.getIndexedQueryMode()) : null;
            return remoteQueryManager.executeQuery(request.getQueryString(), request.getNamedParametersMap(), startOffset, maxResults, queryMode, cache, requestMediaType);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debugf(e, "Error executing remote query : %s", e.getMessage());
            }
            throw e;
        }
    }
}

