package org.infinispan.query.remote.impl.logging;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.infinispan.commons.CacheException;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-09-15T07:39:38+0000")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String unknownField = "ISPN028001: Unknown field %s in type %s";
    protected String unknownField$str() {
        return unknownField;
    }
    @Override
    public final IllegalArgumentException unknownField(final String fieldName, final String fullyQualifiedTypeName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownField$str(), fieldName, fullyQualifiedTypeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fieldIsNotIndexed = "ISPN028002: Field %s from type %s is not indexed";
    protected String fieldIsNotIndexed$str() {
        return fieldIsNotIndexed;
    }
    @Override
    public final IllegalArgumentException fieldIsNotIndexed(final String fieldName, final String fullyQualifiedTypeName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), fieldIsNotIndexed$str(), fieldName, fullyQualifiedTypeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorExecutingQuery = "ISPN028003: An exception has occurred during query execution";
    protected String errorExecutingQuery$str() {
        return errorExecutingQuery;
    }
    @Override
    public final CacheException errorExecutingQuery(final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), errorExecutingQuery$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String queryingNotEnabled = "ISPN028004: Querying is not enabled on cache %s";
    protected String queryingNotEnabled$str() {
        return queryingNotEnabled;
    }
    @Override
    public final CacheException queryingNotEnabled(final String cacheName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), queryingNotEnabled$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fieldIsNotAnalyzed = "ISPN028005: Field %s from type %s is not analyzed";
    protected String fieldIsNotAnalyzed$str() {
        return fieldIsNotAnalyzed;
    }
    @Override
    public final IllegalArgumentException fieldIsNotAnalyzed(final String fieldName, final String fullyQualifiedTypeName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), fieldIsNotAnalyzed$str(), fieldName, fullyQualifiedTypeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorFiltering = "ISPN028006: An exception has occurred during filter execution";
    protected String errorFiltering$str() {
        return errorFiltering;
    }
    @Override
    public final CacheException errorFiltering(final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), errorFiltering$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyMustBeString = "ISPN028007: The key must be a String : %s";
    protected String keyMustBeString$str() {
        return keyMustBeString;
    }
    @Override
    public final CacheException keyMustBeString(final Class<?> c) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), keyMustBeString$str(), c));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String valueMustBeString = "ISPN028008: The value must be a String : %s";
    protected String valueMustBeString$str() {
        return valueMustBeString;
    }
    @Override
    public final CacheException valueMustBeString(final Class<?> c) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), valueMustBeString$str(), c));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyMustBeStringEndingWithProto = "ISPN028009: The key must be a String ending with \".proto\" : %s";
    protected String keyMustBeStringEndingWithProto$str() {
        return keyMustBeStringEndingWithProto;
    }
    @Override
    public final CacheException keyMustBeStringEndingWithProto(final Object key) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), keyMustBeStringEndingWithProto$str(), key));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToParseProtoFile0 = "ISPN028010: Failed to parse proto file.";
    protected String failedToParseProtoFile0$str() {
        return failedToParseProtoFile0;
    }
    @Override
    public final CacheException failedToParseProtoFile(final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), failedToParseProtoFile0$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToParseProtoFile1 = "ISPN028011: Failed to parse proto file : %s";
    protected String failedToParseProtoFile1$str() {
        return failedToParseProtoFile1;
    }
    @Override
    public final CacheException failedToParseProtoFile(final String fileName, final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), failedToParseProtoFile1$str(), fileName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void legacyIndexingIsDeprecated(final String typeName, final String fileName) {
        super.log.logf(FQCN, WARN, null, legacyIndexingIsDeprecated$str(), typeName, fileName);
    }
    private static final String legacyIndexingIsDeprecated = "ISPN028012: Using deprecated legacy indexing mode (all fields) for message type '%s' missing indexing annotations defined in file '%s'. Please annotate your message type for indexing or add 'option indexed_by_default = false;' to your schema file to disable indexing of message types that do not have indexing annotations.";
    protected String legacyIndexingIsDeprecated$str() {
        return legacyIndexingIsDeprecated;
    }
    private static final String errorInitializingSerCtx = "ISPN028013: Error during execution of protostream serialization context initializer";
    protected String errorInitializingSerCtx$str() {
        return errorInitializingSerCtx;
    }
    @Override
    public final CacheException errorInitializingSerCtx(final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), errorInitializingSerCtx$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cacheDoesNotSupportCommand = "ISPN028014: The '%s' cache does not support commands of type %s";
    protected String cacheDoesNotSupportCommand$str() {
        return cacheDoesNotSupportCommand;
    }
    @Override
    public final CacheException cacheDoesNotSupportCommand(final String cacheName, final String commandType) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cacheDoesNotSupportCommand$str(), cacheName, commandType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
