/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.query.dsl.EntityContext;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.objectfilter.impl.syntax.AggregationExpr;
import org.infinispan.objectfilter.impl.syntax.AndExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.ExprVisitor;
import org.infinispan.objectfilter.impl.syntax.FullTextBoostExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextOccurExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextRangeExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextRegexpExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextTermExpr;
import org.infinispan.objectfilter.impl.syntax.IsNullExpr;
import org.infinispan.objectfilter.impl.syntax.LikeExpr;
import org.infinispan.objectfilter.impl.syntax.NotExpr;
import org.infinispan.objectfilter.impl.syntax.OrExpr;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.query.dsl.embedded.impl.LuceneQueryMaker;
import org.infinispan.query.remote.impl.indexing.FieldMapping;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;
import org.infinispan.query.remote.impl.logging.Log;

final class ProtobufFieldBridgeAndAnalyzerProvider
implements LuceneQueryMaker.FieldBridgeAndAnalyzerProvider<Descriptor> {
    private static final Log log = (Log)LogFactory.getLog(ProtobufFieldBridgeAndAnalyzerProvider.class, Log.class);

    ProtobufFieldBridgeAndAnalyzerProvider() {
    }

    public FieldBridge getFieldBridge(Descriptor typeMetadata, String[] propertyPath) {
        FieldMapping fieldMapping;
        FieldDescriptor fd = this.getFieldDescriptor(typeMetadata, propertyPath);
        IndexingMetadata indexingMetadata = (IndexingMetadata)fd.getContainingMessage().getProcessedAnnotation("Indexed");
        FieldMapping fieldMapping2 = fieldMapping = indexingMetadata != null ? indexingMetadata.getFieldMapping(fd.getName()) : null;
        if (fieldMapping != null) {
            return fieldMapping.fieldBridge();
        }
        return FieldMapping.getDefaultFieldBridge(fd.getType());
    }

    private FieldDescriptor getFieldDescriptor(Descriptor typeMetadata, String[] propertyPath) {
        Descriptor messageDescriptor = typeMetadata;
        FieldDescriptor fd = null;
        for (int i = 0; i < propertyPath.length; ++i) {
            String name = propertyPath[i];
            fd = messageDescriptor.findFieldByName(name);
            if (fd == null) {
                throw log.unknownField(name, messageDescriptor.getFullName());
            }
            IndexingMetadata indexingMetadata = (IndexingMetadata)messageDescriptor.getProcessedAnnotation("Indexed");
            if (indexingMetadata != null && !indexingMetadata.isFieldIndexed(name)) {
                throw log.fieldIsNotIndexed(name, messageDescriptor.getFullName());
            }
            if (i >= propertyPath.length - 1) continue;
            messageDescriptor = fd.getMessageType();
        }
        return fd;
    }

    public Analyzer getAnalyzer(SearchIntegrator searchIntegrator, Descriptor typeMetadata, String[] propertyPath) {
        String analyzerName = this.getAnalyzerName(typeMetadata, propertyPath, true);
        return analyzerName != null ? searchIntegrator.getAnalyzer(analyzerName) : null;
    }

    private String getAnalyzerName(Descriptor typeMetadata, String[] propertyPath, boolean complain) {
        Descriptor messageDescriptor = typeMetadata;
        for (int i = 0; i < propertyPath.length; ++i) {
            String name = propertyPath[i];
            FieldDescriptor fd = messageDescriptor.findFieldByName(name);
            if (fd == null) {
                throw log.unknownField(name, messageDescriptor.getFullName());
            }
            IndexingMetadata indexingMetadata = (IndexingMetadata)messageDescriptor.getProcessedAnnotation("Indexed");
            if (indexingMetadata == null || !indexingMetadata.isFieldIndexed(name)) {
                if (!complain) break;
                throw log.fieldIsNotIndexed(name, messageDescriptor.getFullName());
            }
            if (i < propertyPath.length - 1) {
                messageDescriptor = fd.getMessageType();
                continue;
            }
            FieldMapping fieldMapping = indexingMetadata.getFieldMapping(name);
            if (fieldMapping == null) {
                if (!complain) break;
                throw log.fieldIsNotAnalyzed(name, messageDescriptor.getFullName());
            }
            String analyzerName = fieldMapping.analyzer();
            if (analyzerName == null || analyzerName.isEmpty()) {
                analyzerName = indexingMetadata.analyzer();
            }
            if (analyzerName == null || analyzerName.isEmpty()) continue;
            return analyzerName;
        }
        return null;
    }

    public void overrideAnalyzers(final IckleParsingResult<Descriptor> parsingResult, final EntityContext entityContext) {
        class AnalyzerCollector
        extends ExprVisitor {
            AnalyzerCollector() {
            }

            private void collectAnalyzer(PropertyValueExpr propertyValueExpr) {
                String analyzerName = ProtobufFieldBridgeAndAnalyzerProvider.this.getAnalyzerName((Descriptor)parsingResult.getTargetEntityMetadata(), propertyValueExpr.getPropertyPath().asArrayPath(), false);
                if (analyzerName != null) {
                    entityContext.overridesForField(propertyValueExpr.getPropertyPath().asStringPathWithoutAlias(), analyzerName);
                }
            }

            public BooleanExpr visit(FullTextBoostExpr fullTextBoostExpr) {
                fullTextBoostExpr.getChild().acceptVisitor((Visitor)this);
                return fullTextBoostExpr;
            }

            public BooleanExpr visit(FullTextOccurExpr fullTextOccurExpr) {
                fullTextOccurExpr.getChild().acceptVisitor((Visitor)this);
                return fullTextOccurExpr;
            }

            public BooleanExpr visit(FullTextTermExpr fullTextTermExpr) {
                PropertyValueExpr propertyValueExpr = (PropertyValueExpr)fullTextTermExpr.getChild();
                this.collectAnalyzer(propertyValueExpr);
                return fullTextTermExpr;
            }

            public BooleanExpr visit(FullTextRegexpExpr fullTextRegexpExpr) {
                PropertyValueExpr propertyValueExpr = (PropertyValueExpr)fullTextRegexpExpr.getChild();
                this.collectAnalyzer(propertyValueExpr);
                return fullTextRegexpExpr;
            }

            public BooleanExpr visit(FullTextRangeExpr fullTextRangeExpr) {
                PropertyValueExpr propertyValueExpr = (PropertyValueExpr)fullTextRangeExpr.getChild();
                this.collectAnalyzer(propertyValueExpr);
                return fullTextRangeExpr;
            }

            public BooleanExpr visit(NotExpr notExpr) {
                notExpr.getChild().acceptVisitor((Visitor)this);
                return notExpr;
            }

            public BooleanExpr visit(OrExpr orExpr) {
                for (BooleanExpr c : orExpr.getChildren()) {
                    c.acceptVisitor((Visitor)this);
                }
                return orExpr;
            }

            public BooleanExpr visit(AndExpr andExpr) {
                for (BooleanExpr c : andExpr.getChildren()) {
                    c.acceptVisitor((Visitor)this);
                }
                return andExpr;
            }

            public BooleanExpr visit(ConstantBooleanExpr constantBooleanExpr) {
                return constantBooleanExpr;
            }

            public BooleanExpr visit(IsNullExpr isNullExpr) {
                PropertyValueExpr propertyValueExpr = (PropertyValueExpr)isNullExpr.getChild();
                this.collectAnalyzer(propertyValueExpr);
                return isNullExpr;
            }

            public BooleanExpr visit(ComparisonExpr comparisonExpr) {
                PropertyValueExpr propertyValueExpr = (PropertyValueExpr)comparisonExpr.getLeftChild();
                this.collectAnalyzer(propertyValueExpr);
                return comparisonExpr;
            }

            public BooleanExpr visit(LikeExpr likeExpr) {
                PropertyValueExpr propertyValueExpr = (PropertyValueExpr)likeExpr.getChild();
                this.collectAnalyzer(propertyValueExpr);
                return likeExpr;
            }

            public ValueExpr visit(ConstantValueExpr constantValueExpr) {
                return constantValueExpr;
            }

            public ValueExpr visit(PropertyValueExpr propertyValueExpr) {
                return propertyValueExpr;
            }

            public ValueExpr visit(AggregationExpr aggregationExpr) {
                return aggregationExpr;
            }
        }
        if (parsingResult.getWhereClause() != null) {
            parsingResult.getWhereClause().acceptVisitor((Visitor)new AnalyzerCollector());
        }
        if (parsingResult.getHavingClause() != null) {
            parsingResult.getHavingClause().acceptVisitor((Visitor)new AnalyzerCollector());
        }
    }
}

