/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.io.IOException;
import java.nio.channels.FileChannel;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.persistence.sifs.EntryHeader;
import org.infinispan.persistence.sifs.FileProvider;

class EntryRecord {
    private EntryHeader header;
    private byte[] key;
    private byte[] metadata;
    private byte[] value;

    public EntryRecord(EntryHeader header, byte[] key, byte[] metadata, byte[] value) {
        this.header = header;
        this.key = key;
        this.metadata = metadata;
        this.value = value;
    }

    public EntryHeader getHeader() {
        return this.header;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getMetadata() {
        return this.metadata;
    }

    public byte[] getValue() {
        return this.value;
    }

    public EntryRecord loadMetadataAndValue(FileProvider.Handle handle, int offset) throws IOException {
        int metadataOffset = offset + 24 + this.header.keyLength();
        if (this.header.metadataLength() > 0) {
            this.metadata = new byte[this.header.metadataLength()];
            if (EntryRecord.read(handle, java.nio.ByteBuffer.wrap(this.metadata), metadataOffset, this.header.metadataLength()) < 0) {
                throw new IllegalStateException("End of file reached when reading metadata on " + handle.getFileId() + ":" + offset + ": " + this.header);
            }
        }
        assert (this.header.valueLength() > 0);
        this.value = new byte[this.header.valueLength()];
        if (EntryRecord.read(handle, java.nio.ByteBuffer.wrap(this.value), metadataOffset + this.header.metadataLength(), this.header.valueLength()) < 0) {
            throw new IllegalStateException("End of file reached when reading value on " + handle.getFileId() + ":" + offset + ": " + this.header);
        }
        return this;
    }

    public static EntryHeader readEntryHeader(FileProvider.Handle handle, long offset) throws IOException {
        java.nio.ByteBuffer header = java.nio.ByteBuffer.allocate(24);
        if (EntryRecord.read(handle, header, offset, 24) < 0) {
            return null;
        }
        header.flip();
        try {
            return new EntryHeader(header);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Error reading from " + handle.getFileId() + ":" + offset);
        }
    }

    public static byte[] readKey(FileProvider.Handle handle, EntryHeader header, long offset) throws IOException {
        byte[] key = new byte[header.keyLength()];
        if (EntryRecord.read(handle, java.nio.ByteBuffer.wrap(key), offset + 24L, header.keyLength()) < 0) {
            return null;
        }
        return key;
    }

    public static byte[] readMetadata(FileProvider.Handle handle, EntryHeader header, long offset) throws IOException {
        assert (header.metadataLength() > 0);
        byte[] metadata = new byte[header.metadataLength()];
        if (EntryRecord.read(handle, java.nio.ByteBuffer.wrap(metadata), offset + 24L + (long)header.keyLength(), header.metadataLength()) < 0) {
            throw new IllegalStateException("End of file reached when reading metadata on " + handle.getFileId() + ":" + offset + ": " + header);
        }
        return metadata;
    }

    public static byte[] readValue(FileProvider.Handle handle, EntryHeader header, long offset) throws IOException {
        assert (header.valueLength() > 0);
        byte[] value = new byte[header.valueLength()];
        if (EntryRecord.read(handle, java.nio.ByteBuffer.wrap(value), offset + 24L + (long)header.keyLength() + (long)header.metadataLength(), header.valueLength()) < 0) {
            throw new IllegalStateException("End of file reached when reading metadata on " + handle.getFileId() + ":" + offset + ": " + header);
        }
        return value;
    }

    private static int read(FileProvider.Handle handle, java.nio.ByteBuffer buffer, long position, int length) throws IOException {
        int newRead;
        int read = 0;
        do {
            if ((newRead = handle.read(buffer, position + (long)read)) >= 0) continue;
            return -1;
        } while ((read += newRead) < length);
        return read;
    }

    private static boolean read(FileChannel fileChannel, java.nio.ByteBuffer buffer, int length) throws IOException {
        int newRead;
        int read = 0;
        do {
            if ((newRead = fileChannel.read(buffer)) >= 0) continue;
            return false;
        } while ((read += newRead) < length);
        return true;
    }

    public static void writeEntry(FileChannel fileChannel, byte[] serializedKey, byte[] serializedMetadata, byte[] serializedValue, long seqId, long expiration) throws IOException {
        java.nio.ByteBuffer header = java.nio.ByteBuffer.allocate(24);
        header.putShort((short)serializedKey.length);
        header.putShort(serializedMetadata == null ? (short)0 : (short)serializedMetadata.length);
        header.putInt(serializedValue == null ? 0 : serializedValue.length);
        header.putLong(seqId);
        header.putLong(expiration);
        header.flip();
        EntryRecord.write(fileChannel, header);
        EntryRecord.write(fileChannel, java.nio.ByteBuffer.wrap(serializedKey));
        if (serializedMetadata != null) {
            EntryRecord.write(fileChannel, java.nio.ByteBuffer.wrap(serializedMetadata));
        }
        if (serializedValue != null) {
            EntryRecord.write(fileChannel, java.nio.ByteBuffer.wrap(serializedValue));
        }
    }

    public static void writeEntry(FileChannel fileChannel, ByteBuffer serializedKey, ByteBuffer serializedMetadata, ByteBuffer serializedValue, long seqId, long expiration) throws IOException {
        java.nio.ByteBuffer header = java.nio.ByteBuffer.allocate(24);
        header.putShort((short)serializedKey.getLength());
        header.putShort(serializedMetadata == null ? (short)0 : (short)serializedMetadata.getLength());
        header.putInt(serializedValue == null ? 0 : serializedValue.getLength());
        header.putLong(seqId);
        header.putLong(expiration);
        header.flip();
        EntryRecord.write(fileChannel, header);
        EntryRecord.write(fileChannel, java.nio.ByteBuffer.wrap(serializedKey.getBuf(), serializedKey.getOffset(), serializedKey.getLength()));
        if (serializedMetadata != null) {
            EntryRecord.write(fileChannel, java.nio.ByteBuffer.wrap(serializedMetadata.getBuf(), serializedMetadata.getOffset(), serializedMetadata.getLength()));
        }
        if (serializedValue != null) {
            EntryRecord.write(fileChannel, java.nio.ByteBuffer.wrap(serializedValue.getBuf(), serializedValue.getOffset(), serializedValue.getLength()));
        }
    }

    private static void write(FileChannel fileChannel, java.nio.ByteBuffer buffer) throws IOException {
        while (buffer.hasRemaining()) {
            fileChannel.write(buffer);
        }
    }
}

