/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.persistence.sifs.Compactor;
import org.infinispan.persistence.sifs.EntryPosition;
import org.infinispan.persistence.sifs.EntryRecord;
import org.infinispan.persistence.sifs.FileProvider;
import org.infinispan.persistence.sifs.IndexNode;
import org.infinispan.persistence.sifs.IndexQueue;
import org.infinispan.persistence.sifs.IndexRequest;
import org.infinispan.persistence.sifs.TemporaryTable;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

class Index {
    private static final Log log = LogFactory.getLog(Index.class);
    private static final boolean trace = log.isTraceEnabled();
    private final String indexDir;
    private final FileProvider fileProvider;
    private final Compactor compactor;
    private final int minNodeSize;
    private final int maxNodeSize;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Segment[] segments;
    private final TimeService timeService;
    private final Equivalence<Object> keyEquivalence;

    public Index(FileProvider fileProvider, String indexDir, int segments, int minNodeSize, int maxNodeSize, IndexQueue indexQueue, TemporaryTable temporaryTable, Compactor compactor, TimeService timeService, Equivalence<Object> keyEquivalence) throws IOException {
        this.fileProvider = fileProvider;
        this.compactor = compactor;
        this.timeService = timeService;
        this.keyEquivalence = keyEquivalence;
        this.indexDir = indexDir;
        this.minNodeSize = minNodeSize;
        this.maxNodeSize = maxNodeSize;
        new File(indexDir).mkdirs();
        this.segments = new Segment[segments];
        for (int i = 0; i < segments; ++i) {
            this.segments[i] = new Segment(i, indexQueue.subQueue(i), temporaryTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryRecord getRecord(Object key, byte[] serializedKey) throws IOException {
        int segment = Math.abs(this.keyEquivalence.hashCode(key)) % this.segments.length;
        this.lock.readLock().lock();
        try {
            EntryRecord entryRecord = (EntryRecord)IndexNode.applyOnLeaf(this.segments[segment], serializedKey, this.segments[segment].rootReadLock(), IndexNode.ReadOperation.GET_RECORD);
            return entryRecord;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryPosition getPosition(Object key, byte[] serializedKey) throws IOException {
        int segment = Math.abs(this.keyEquivalence.hashCode(key)) % this.segments.length;
        this.lock.readLock().lock();
        try {
            EntryPosition entryPosition = (EntryPosition)IndexNode.applyOnLeaf(this.segments[segment], serializedKey, this.segments[segment].rootReadLock(), IndexNode.ReadOperation.GET_POSITION);
            return entryPosition;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void clear() throws IOException {
        this.lock.writeLock().lock();
        try {
            ArrayList<CountDownLatch> pauses = new ArrayList<CountDownLatch>();
            for (Segment seg : this.segments) {
                pauses.add(seg.pauseAndClear());
            }
            for (CountDownLatch pause : pauses) {
                pause.countDown();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void stopOperations() throws InterruptedException {
        for (Segment seg : this.segments) {
            seg.stopOperations();
        }
    }

    public long size() throws InterruptedException {
        long size = 0L;
        for (Segment seg : this.segments) {
            size += seg.size();
        }
        return size;
    }

    static /* synthetic */ boolean access$300() {
        return trace;
    }

    static class IndexSpace {
        protected long offset;
        protected int length;

        public IndexSpace(long offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof IndexSpace)) {
                return false;
            }
            IndexSpace innerNode = (IndexSpace)o;
            if (this.length != innerNode.length) {
                return false;
            }
            return this.offset == innerNode.offset;
        }

        public int hashCode() {
            int result = (int)(this.offset ^ this.offset >>> 32);
            result = 31 * result + this.length;
            return result;
        }

        public String toString() {
            return String.format("[%d-%d(%d)]", this.offset, this.offset + (long)this.length, this.length);
        }
    }

    class Segment
    extends Thread {
        private final BlockingQueue<IndexRequest> indexQueue;
        private final TemporaryTable temporaryTable;
        private final TreeMap<Integer, List<IndexSpace>> freeBlocks;
        private final ReadWriteLock rootLock;
        private final File indexFileFile;
        private FileChannel indexFile;
        private long indexFileSize;
        private AtomicLong size;
        private volatile IndexNode root;

        private Segment(int id, BlockingQueue<IndexRequest> indexQueue, TemporaryTable temporaryTable) throws IOException {
            super("BCS-IndexUpdater-" + id);
            this.freeBlocks = new TreeMap();
            this.rootLock = new ReentrantReadWriteLock();
            this.indexFileSize = 0L;
            this.size = new AtomicLong();
            this.root = IndexNode.emptyWithLeaves(this);
            this.setDaemon(true);
            this.indexQueue = indexQueue;
            this.temporaryTable = temporaryTable;
            this.indexFileFile = new File(Index.this.indexDir, "index." + id);
            this.indexFile = new RandomAccessFile(this.indexFileFile, "rw").getChannel();
            this.indexFile.truncate(0L);
            this.start();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CASE], 7[SWITCH]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public CountDownLatch pauseAndClear() throws InterruptedException, IOException {
            IndexRequest clear = IndexRequest.clearRequest();
            this.indexQueue.put(clear);
            CountDownLatch pause = (CountDownLatch)clear.getResult();
            this.root = IndexNode.emptyWithLeaves(this);
            this.indexFile.truncate(0L);
            this.indexFileSize = 0L;
            this.freeBlocks.clear();
            this.size.set(0L);
            return pause;
        }

        public long size() throws InterruptedException {
            IndexRequest sizeRequest = IndexRequest.sizeRequest();
            this.indexQueue.put(sizeRequest);
            return (Long)sizeRequest.getResult();
        }

        public FileChannel getIndexFile() {
            return this.indexFile;
        }

        public FileProvider getFileProvider() {
            return Index.this.fileProvider;
        }

        public Compactor getCompactor() {
            return Index.this.compactor;
        }

        public IndexNode getRoot() {
            return this.root;
        }

        public void setRoot(IndexNode root) {
            this.rootLock.writeLock().lock();
            this.root = root;
            this.rootLock.writeLock().unlock();
        }

        public int getMaxNodeSize() {
            return Index.this.maxNodeSize;
        }

        public int getMinNodeSize() {
            return Index.this.minNodeSize;
        }

        IndexSpace allocateIndexSpace(int length) {
            Map.Entry<Integer, List<IndexSpace>> entry = this.freeBlocks.ceilingEntry(length);
            if (entry == null || entry.getValue().isEmpty()) {
                long oldSize = this.indexFileSize;
                this.indexFileSize += (long)length;
                return new IndexSpace(oldSize, length);
            }
            return entry.getValue().remove(entry.getValue().size() - 1);
        }

        void freeIndexSpace(long offset, int length) {
            if (length <= 0) {
                throw new IllegalArgumentException("Offset=" + offset + ", length=" + length);
            }
            if (offset + (long)length < this.indexFileSize) {
                List<IndexSpace> list = this.freeBlocks.get(length);
                if (list == null) {
                    list = new ArrayList<IndexSpace>();
                    this.freeBlocks.put(length, list);
                }
                list.add(new IndexSpace(offset, length));
            } else {
                this.indexFileSize -= (long)length;
                try {
                    this.indexFile.truncate(this.indexFileSize);
                }
                catch (IOException e) {
                    log.warn((Object)"Cannot truncate index", (Throwable)e);
                }
            }
        }

        public Lock rootReadLock() {
            return this.rootLock.readLock();
        }

        public void stopOperations() throws InterruptedException {
            this.indexQueue.put(IndexRequest.stopRequest());
            this.join();
        }

        public TimeService getTimeService() {
            return Index.this.timeService;
        }
    }
}

