/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.util.concurrent.ConcurrentMap;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.persistence.sifs.EntryPosition;

public class TemporaryTable {
    private ConcurrentMap<Object, Entry> table;

    public TemporaryTable(int capacity, Equivalence<Object> keyEquivalence) {
        this.table = CollectionFactory.makeConcurrentMap((int)capacity, keyEquivalence, (Equivalence)AnyEquivalence.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Object key, int file, int offset) {
        Entry entry;
        while ((entry = this.table.putIfAbsent(key, new Entry(file, offset))) != null) {
            Entry entry2 = entry;
            synchronized (entry2) {
                if (entry.isRemoved()) {
                    continue;
                }
                entry.update(file, offset);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConditionally(Object key, int file, int offset, int prevFile, int prevOffset) {
        Entry entry;
        while ((entry = this.table.putIfAbsent(key, new Entry(file, offset))) != null) {
            Entry entry2 = entry;
            synchronized (entry2) {
                if (entry.isRemoved()) {
                    continue;
                }
                if (entry.getFile() == prevFile && entry.getOffset() == prevOffset) {
                    entry.update(file, offset);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryPosition get(Object key) {
        int offset;
        int file;
        Entry entry = (Entry)this.table.get(key);
        if (entry == null) {
            return null;
        }
        Entry entry2 = entry;
        synchronized (entry2) {
            file = entry.getFile();
            offset = entry.getOffset();
        }
        return new EntryPosition(file, offset);
    }

    public void clear() {
        this.table.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConditionally(Object key, int file, int offset) {
        Entry tempEntry = (Entry)this.table.get(key);
        if (tempEntry != null) {
            Entry entry = tempEntry;
            synchronized (entry) {
                if (tempEntry.getFile() == file && tempEntry.getOffset() == offset) {
                    this.table.remove(key, tempEntry);
                    tempEntry.setRemoved(true);
                }
            }
        }
    }

    private static class Entry {
        private int file;
        private int offset;
        private boolean removed = false;

        Entry(int file, int offset) {
            this.file = file;
            this.offset = offset;
        }

        public int getFile() {
            return this.file;
        }

        public int getOffset() {
            return this.offset;
        }

        public void update(int currentFile, int currentOffset) {
            this.file = currentFile;
            this.offset = currentOffset;
        }

        public boolean isRemoved() {
            return this.removed;
        }

        public void setRemoved(boolean removed) {
            this.removed = removed;
        }
    }
}

