/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser70;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.persistence.sifs.configuration.Attribute;
import org.infinispan.persistence.sifs.configuration.Element;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;

@Namespaces(value={@Namespace(uri="urn:infinispan:config:soft-index:7.0", root="softIndexStore"), @Namespace(root="softIndexStore")})
public class SoftIndexFileStoreConfigurationParser70
implements ConfigurationParser {
    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case SOFT_INDEX_FILE_STORE: {
                this.parseSoftIndexFileStore(reader, (SoftIndexFileStoreConfigurationBuilder)builder.persistence().addStore(SoftIndexFileStoreConfigurationBuilder.class));
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    private void parseSoftIndexFileStore(XMLExtendedStreamReader reader, SoftIndexFileStoreConfigurationBuilder builder) throws XMLStreamException {
        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            String attrName = reader.getAttributeLocalName(i);
            Attribute attribute = Attribute.forName(attrName);
            switch (attribute) {
                case DATA_LOCATION: {
                    builder.dataLocation(value);
                    continue block12;
                }
                case INDEX_LOCATION: {
                    builder.indexLocation(value);
                    continue block12;
                }
                case INDEX_SEGMENTS: {
                    builder.indexSegments(Integer.parseInt(value));
                    continue block12;
                }
                case INDEX_QUEUE_LENGTH: {
                    builder.indexQueueLength(Integer.parseInt(value));
                    continue block12;
                }
                case MAX_FILE_SIZE: {
                    builder.maxFileSize(Integer.parseInt(value));
                    continue block12;
                }
                case MIN_NODE_SIZE: {
                    builder.minNodeSize(Integer.parseInt(value));
                    continue block12;
                }
                case MAX_NODE_SIZE: {
                    builder.maxNodeSize(Integer.parseInt(value));
                    continue block12;
                }
                case SYNC_WRITES: {
                    builder.syncWrites(Boolean.parseBoolean(value));
                    continue block12;
                }
                case OPEN_FILES_LIMIT: {
                    builder.openFilesLimit(Integer.parseInt(value));
                    continue block12;
                }
                case COMPACTION_THRESHOLD: {
                    builder.compactionThreshold(Double.parseDouble(value));
                    continue block12;
                }
                default: {
                    Parser70.parseStoreAttribute((XMLExtendedStreamReader)reader, (int)i, (AbstractStoreConfigurationBuilder)builder);
                }
            }
        }
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }
}

