/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfiguration;

public class SoftIndexFileStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<SoftIndexFileStoreConfiguration, SoftIndexFileStoreConfigurationBuilder> {
    private String dataLocation = "Infinispan-SoftIndexFileStore-Data";
    private String indexLocation = "Infinispan-SoftIndexFileStore-Index";
    private int indexSegments = 3;
    private int maxFileSize = 0x1000000;
    private int minNodeSize = -1;
    private int maxNodeSize = 4096;
    private int indexQueueLength = 1000;
    private boolean syncWrites = false;
    private int openFilesLimit = 1000;
    private double compactionThreshold = 0.5;

    public SoftIndexFileStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder);
    }

    public SoftIndexFileStoreConfigurationBuilder dataLocation(String dataLocation) {
        this.dataLocation = dataLocation;
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder indexLocation(String indexLocation) {
        this.indexLocation = indexLocation;
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder indexSegments(int indexSegments) {
        this.indexSegments = indexSegments;
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder maxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder minNodeSize(int minNodeSize) {
        this.minNodeSize = minNodeSize;
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder maxNodeSize(int maxNodeSize) {
        this.maxNodeSize = maxNodeSize;
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder indexQueueLength(int indexQueueLength) {
        this.indexQueueLength = indexQueueLength;
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder syncWrites(boolean syncWrites) {
        this.syncWrites = syncWrites;
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder openFilesLimit(int openFilesLimit) {
        this.openFilesLimit = openFilesLimit;
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder compactionThreshold(double compactionThreshold) {
        this.compactionThreshold = compactionThreshold;
        return this;
    }

    public SoftIndexFileStoreConfiguration create() {
        return new SoftIndexFileStoreConfiguration(this.purgeOnStartup, this.fetchPersistentState, this.ignoreModifications, this.async.create(), this.singletonStore.create(), this.preload, this.shared, this.properties, this.dataLocation, this.indexLocation, this.indexSegments, this.maxFileSize, this.minNodeSize < 0 ? this.maxNodeSize / 3 : this.minNodeSize, this.maxNodeSize, this.indexQueueLength, this.syncWrites, this.openFilesLimit, this.compactionThreshold);
    }

    public Builder<?> read(SoftIndexFileStoreConfiguration template) {
        this.dataLocation = template.dataLocation();
        this.indexLocation = template.indexLocation();
        this.indexSegments = template.indexSegments();
        this.maxFileSize = template.maxFileSize();
        this.minNodeSize = template.minNodeSize();
        this.maxNodeSize = template.maxNodeSize();
        this.indexQueueLength = template.indexQueueLength();
        this.syncWrites = template.syncWrites();
        this.openFilesLimit = template.openFilesLimit();
        this.compactionThreshold = template.compactionThreshold();
        this.fetchPersistentState = template.fetchPersistentState();
        this.ignoreModifications = template.ignoreModifications();
        this.properties = template.properties();
        this.purgeOnStartup = template.purgeOnStartup();
        this.async.read(template.async());
        this.singletonStore.read(template.singletonStore());
        this.preload = template.preload();
        this.shared = template.shared();
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder self() {
        return this;
    }
}

