/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    COMPACTION_THRESHOLD("compactionThreshold"),
    DATA_LOCATION("dataLocation"),
    INDEX_QUEUE_LENGTH("indexQueueLength"),
    INDEX_LOCATION("indexLocation"),
    INDEX_SEGMENTS("indexSegments"),
    MAX_FILE_SIZE("maxFileSize"),
    MAX_NODE_SIZE("maxNodeSize"),
    MIN_NODE_SIZE("minNodeSize"),
    OPEN_FILES_LIMIT("openFilesLimit"),
    SYNC_WRITES("syncWrites");

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>(64);
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

