/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.AbstractIterator;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.sifs.Compactor;
import org.infinispan.persistence.sifs.EntryHeader;
import org.infinispan.persistence.sifs.EntryMetadata;
import org.infinispan.persistence.sifs.EntryPosition;
import org.infinispan.persistence.sifs.EntryRecord;
import org.infinispan.persistence.sifs.FileProvider;
import org.infinispan.persistence.sifs.Index;
import org.infinispan.persistence.sifs.IndexNode;
import org.infinispan.persistence.sifs.IndexRequest;
import org.infinispan.persistence.sifs.Log;
import org.infinispan.persistence.sifs.LogAppender;
import org.infinispan.persistence.sifs.TemporaryTable;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfiguration;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.concurrent.ActionSequencer;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

public class NonBlockingSoftIndexFileStore<K, V>
implements NonBlockingStore<K, V> {
    private static final Log log = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    public static final String PREFIX_10_1 = "";
    public static final String PREFIX_11_0 = "ispn.";
    public static final String PREFIX_12_0 = "ispn12.";
    public static final String PREFIX_LATEST = "ispn12.";
    private SoftIndexFileStoreConfiguration configuration;
    private TemporaryTable temporaryTable;
    private FileProvider fileProvider;
    private LogAppender logAppender;
    private Index index;
    private Compactor compactor;
    private Marshaller marshaller;
    private ByteBufferFactory byteBufferFactory;
    private MarshallableEntryFactory<K, V> marshallableEntryFactory;
    private TimeService timeService;
    private int maxKeyLength;
    private BlockingManager blockingManager;
    private ActionSequencer sizeAndClearSequencer;
    private KeyPartitioner keyPartitioner;
    private InitializationContext ctx;

    public Set<NonBlockingStore.Characteristic> characteristics() {
        return EnumSet.of(NonBlockingStore.Characteristic.BULK_READ, NonBlockingStore.Characteristic.SEGMENTABLE);
    }

    public CompletionStage<Void> addSegments(IntSet segments) {
        this.temporaryTable.addSegments(segments);
        return CompletableFutures.completedNull();
    }

    public CompletionStage<Void> removeSegments(IntSet segments) {
        this.temporaryTable.removeSegments(segments);
        return CompletableFutures.completedNull();
    }

    public CompletionStage<Void> start(InitializationContext ctx) {
        this.ctx = ctx;
        this.keyPartitioner = ctx.getKeyPartitioner();
        this.blockingManager = ctx.getBlockingManager();
        this.sizeAndClearSequencer = new ActionSequencer(this.blockingManager.asExecutor("SIFS-sizeOrClear"), false, this.timeService);
        this.configuration = (SoftIndexFileStoreConfiguration)ctx.getConfiguration();
        this.marshaller = ctx.getPersistenceMarshaller();
        this.marshallableEntryFactory = ctx.getMarshallableEntryFactory();
        this.byteBufferFactory = ctx.getByteBufferFactory();
        this.timeService = ctx.getTimeService();
        this.maxKeyLength = this.configuration.maxNodeSize() - IndexNode.RESERVED_SPACE;
        Configuration cacheConfig = ctx.getCache().getCacheConfiguration();
        this.temporaryTable = new TemporaryTable(cacheConfig.clustering().hash().numSegments());
        if (!cacheConfig.clustering().cacheMode().needsStateTransfer()) {
            this.temporaryTable.addSegments(IntSets.immutableRangeSet((int)cacheConfig.clustering().hash().numSegments()));
        }
        this.fileProvider = new FileProvider(this.getDataLocation(), this.configuration.openFilesLimit(), "ispn12.", this.configuration.maxFileSize());
        this.compactor = new Compactor(this.fileProvider, this.temporaryTable, this.marshaller, this.timeService, this.keyPartitioner, this.configuration.maxFileSize(), this.configuration.compactionThreshold(), this.blockingManager.asExecutor("compactor"));
        try {
            this.index = new Index(ctx.getNonBlockingManager(), this.fileProvider, this.getIndexLocation(), this.configuration.indexSegments(), this.configuration.minNodeSize(), this.configuration.maxNodeSize(), this.temporaryTable, this.compactor, this.timeService);
        }
        catch (IOException e) {
            throw log.cannotOpenIndex(this.configuration.indexLocation(), e);
        }
        this.compactor.setIndex(this.index);
        this.logAppender = new LogAppender(ctx.getNonBlockingManager(), this.index, this.temporaryTable, this.compactor, this.fileProvider, this.configuration.syncWrites(), this.configuration.maxFileSize());
        this.logAppender.start(this.blockingManager.asExecutor("sifs-log-processor"));
        this.startIndex();
        AtomicLong maxSeqId = new AtomicLong(0L);
        if (!this.configuration.purgeOnStartup()) {
            return this.blockingManager.runBlocking(() -> {
                boolean migrateData = false;
                FileProvider oldFileProvider = new FileProvider(this.getDataLocation(), this.configuration.openFilesLimit(), PREFIX_10_1, this.configuration.maxFileSize());
                if (oldFileProvider.hasFiles()) {
                    throw org.infinispan.util.logging.Log.PERSISTENCE.persistedDataMigrationAcrossMajorVersions();
                }
                oldFileProvider = new FileProvider(this.getDataLocation(), this.configuration.openFilesLimit(), PREFIX_11_0, this.configuration.maxFileSize());
                if (oldFileProvider.hasFiles()) {
                    this.migrateFromOldFormat(oldFileProvider);
                    migrateData = true;
                } else if (this.index.isLoaded()) {
                    log.debug("Not building the index - loaded from persisted state");
                    try {
                        maxSeqId.set(this.index.getMaxSeqId());
                    }
                    catch (IOException e) {
                        log.debug("Failed to load index. Rebuilding it.");
                        this.buildIndex(maxSeqId);
                    }
                } else {
                    log.debug("Building the index");
                    this.buildIndex(maxSeqId);
                }
                if (!migrateData) {
                    this.logAppender.setSeqId(maxSeqId.get() + 1L);
                }
            }, (Object)"soft-index-start");
        }
        log.debug("Not building the index - purge will be executed");
        return CompletableFutures.completedNull();
    }

    private void migrateFromOldFormat(FileProvider oldFileProvider) {
        String cacheName = this.ctx.getCache().getName();
        org.infinispan.util.logging.Log.PERSISTENCE.startMigratingPersistenceData(cacheName);
        try {
            this.index.clear();
        }
        catch (IOException e) {
            throw org.infinispan.util.logging.Log.PERSISTENCE.persistedDataMigrationFailed(cacheName, (Throwable)e);
        }
        boolean transformationRequired = this.ctx.getGlobalConfiguration().serialization().marshaller() == null;
        try (CloseableIterator<Integer> it = oldFileProvider.getFileIterator();){
            while (it.hasNext()) {
                int fileId = (Integer)it.next();
                try (FileProvider.Handle handle = oldFileProvider.getFile(fileId);){
                    EntryHeader header;
                    int offset = 0;
                    while ((header = EntryRecord.readEntryHeader(handle, offset)) != null) {
                        MarshallableEntry entry = this.readEntry(handle, header, offset, null, true, (key, value, meta, internalMeta, created, lastUsed) -> {
                            if (!transformationRequired) {
                                return this.marshallableEntryFactory.create(key, value, meta, internalMeta, created, lastUsed);
                            }
                            try {
                                Object k = this.unmarshallLegacy(key, false);
                                Object v = this.unmarshallLegacy(value, false);
                                Metadata m = (Metadata)this.unmarshallLegacy(meta, true);
                                PrivateMetadata im = internalMeta == null ? null : (PrivateMetadata)this.ctx.getPersistenceMarshaller().objectFromByteBuffer(internalMeta.getBuf());
                                return this.marshallableEntryFactory.create(k, v, m, im, created, lastUsed);
                            }
                            catch (IOException | ClassNotFoundException e) {
                                throw new MarshallingException((Throwable)e);
                            }
                        });
                        int segment = this.keyPartitioner.getSegment(entry.getKey());
                        if (entry.getValueBytes() != null) {
                            CompletionStages.join(this.logAppender.storeRequest(segment, entry));
                        } else {
                            CompletionStages.join(this.logAppender.deleteRequest(segment, entry.getKey(), entry.getKeyBytes()));
                        }
                        offset += header.totalLength();
                    }
                }
                oldFileProvider.deleteFile(fileId);
            }
            org.infinispan.util.logging.Log.PERSISTENCE.persistedDataSuccessfulMigrated(cacheName);
        }
        catch (IOException e) {
            throw org.infinispan.util.logging.Log.PERSISTENCE.persistedDataMigrationFailed(cacheName, (Throwable)e);
        }
    }

    private <T> T unmarshallLegacy(ByteBuffer buf, boolean allowInternal) throws ClassNotFoundException, IOException {
        if (buf == null) {
            return null;
        }
        Marshaller marshaller = this.ctx.getPersistenceMarshaller().getUserMarshaller();
        try {
            return (T)marshaller.objectFromByteBuffer(buf.getBuf(), buf.getOffset(), buf.getLength());
        }
        catch (IllegalArgumentException e) {
            if (allowInternal) {
                return (T)this.ctx.getPersistenceMarshaller().objectFromByteBuffer(buf.getBuf(), buf.getOffset(), buf.getLength());
            }
            throw e;
        }
    }

    private void buildIndex(AtomicLong maxSeqId) {
        Flowable<Integer> filePublisher = this.filePublisher();
        CompletionStage stage = this.handleFilePublisher((Flowable<Integer>)filePublisher.doAfterNext(file -> this.compactor.completeFile((int)file, -1)), false, false, (file, offset, size, serializedKey, entryMetadata, serializedValue, serializedInternalMetadata, seqId, expiration) -> {
            int segment;
            long prevSeqId;
            while (seqId > (prevSeqId = maxSeqId.get()) && !maxSeqId.compareAndSet(prevSeqId, seqId)) {
            }
            Object key = this.marshaller.objectFromByteBuffer(serializedKey);
            if (log.isTraceEnabled()) {
                log.tracef("Loaded %d:%d (seqId %d, expiration %d)", new Object[]{file, offset, seqId, expiration});
            }
            if (this.isSeqIdOld(seqId, segment = this.keyPartitioner.getSegment(key), key, serializedKey)) {
                this.index.handleRequest(IndexRequest.foundOld(segment, key, serializedKey, file, offset));
                return null;
            }
            if (this.temporaryTable.set(segment, key, file, offset)) {
                this.index.handleRequest(IndexRequest.update(segment, key, serializedKey, file, offset, size));
            }
            return null;
        }).ignoreElements().toCompletionStage(null);
        CompletionStages.join((CompletionStage)stage);
    }

    FileProvider getFileProvider() {
        return this.fileProvider;
    }

    private Path getDataLocation() {
        return PersistenceUtil.getQualifiedLocation((GlobalConfiguration)this.ctx.getGlobalConfiguration(), (String)this.configuration.dataLocation(), (String)this.ctx.getCache().getName(), (String)"data");
    }

    protected Path getIndexLocation() {
        return PersistenceUtil.getQualifiedLocation((GlobalConfiguration)this.ctx.getGlobalConfiguration(), (String)this.configuration.indexLocation(), (String)this.ctx.getCache().getName(), (String)"index");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSeqIdOld(long seqId, int segment, Object key, byte[] serializedKey) throws IOException {
        EntryPosition entry;
        FileProvider.Handle handle;
        do {
            if ((entry = this.temporaryTable.get(segment, key)) == null) {
                entry = this.index.getInfo(key, serializedKey);
            }
            if (entry != null) continue;
            if (log.isTraceEnabled()) {
                log.tracef("Did not found position for %s", key);
            }
            return false;
        } while ((handle = this.fileProvider.getFile(entry.file)) == null);
        try {
            int entryOffset = entry.offset < 0 ? ~entry.offset : entry.offset;
            EntryHeader header = EntryRecord.readEntryHeader(handle, entryOffset);
            if (header == null) {
                throw new IOException("Cannot read " + entry.file + ":" + entryOffset);
            }
            if (log.isTraceEnabled()) {
                log.tracef("SeqId on %d:%d is %d", entry.file, entry.offset, header.seqId());
            }
            boolean bl = seqId < header.seqId();
            return bl;
        }
        finally {
            handle.close();
        }
    }

    protected void startIndex() {
        this.index.start(this.blockingManager.asExecutor("sifs-index"));
    }

    protected boolean isIndexLoaded() {
        return this.index.isLoaded();
    }

    public CompletionStage<Void> stop() {
        return this.blockingManager.runBlocking(() -> {
            try {
                this.logAppender.stop();
                this.compactor.stopOperations();
                this.compactor = null;
                CompletionStages.join(this.index.stop());
                this.index = null;
                this.fileProvider.stop();
                this.fileProvider = null;
                this.temporaryTable = null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw log.interruptedWhileStopping(e);
            }
        }, (Object)"soft-index-stop");
    }

    public CompletionStage<Boolean> isAvailable() {
        return CompletableFuture.completedFuture(new File(this.configuration.dataLocation()).exists() && new File(this.configuration.dataLocation()).exists());
    }

    public CompletionStage<Void> clear() {
        return this.sizeAndClearSequencer.orderOnKey((Object)this, () -> {
            CompletionStage compactorSubStage = this.blockingManager.thenApplyBlocking(this.logAppender.clearAndPause(), ignore -> this.compactor.clearAndPause(), (Object)"soft-index-clear-compactor");
            return this.blockingManager.thenRunBlocking(compactorSubStage.thenCompose(Function.identity()), () -> {
                try {
                    this.index.clear();
                }
                catch (IOException e) {
                    throw log.cannotClearIndex(e);
                }
                try {
                    this.fileProvider.clear();
                }
                catch (IOException e) {
                    throw log.cannotClearData(e);
                }
                this.temporaryTable.clear();
                this.compactor.resumeAfterPause();
            }, (Object)"soft-index-clear").thenCompose(v -> this.logAppender.resume());
        });
    }

    public CompletionStage<Long> size(IntSet segments) {
        return this.sizeAndClearSequencer.orderOnKey((Object)this, () -> this.logAppender.pause().thenCompose(ignore -> this.index.size()).thenCompose(v -> this.logAppender.resume().thenApply(ignore -> v)));
    }

    public CompletionStage<Long> approximateSize(IntSet segments) {
        return CompletableFuture.completedFuture(this.index.approximateSize());
    }

    public CompletionStage<Void> write(int segment, MarshallableEntry<? extends K, ? extends V> entry) {
        int keyLength = entry.getKeyBytes().getLength();
        if (keyLength > this.maxKeyLength) {
            throw log.keyIsTooLong(entry.getKey(), keyLength, this.configuration.maxNodeSize(), this.maxKeyLength);
        }
        try {
            return this.logAppender.storeRequest(segment, entry);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public CompletionStage<Boolean> delete(int segment, Object key) {
        try {
            return this.logAppender.deleteRequest(segment, key, this.toBuffer(this.marshaller.objectToByteBuffer(key)));
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public CompletionStage<Boolean> containsKey(int segment, Object key) {
        try {
            EntryPosition entry;
            while ((entry = this.temporaryTable.get(segment, key)) != null) {
                if (entry.offset < 0) {
                    return CompletableFutures.completedFalse();
                }
                FileProvider.Handle handle = this.fileProvider.getFile(entry.file);
                if (handle == null) continue;
                return this.blockingManager.supplyBlocking(() -> {
                    Boolean bl;
                    try {
                        EntryHeader header = EntryRecord.readEntryHeader(handle, entry.offset);
                        if (header == null) {
                            throw new IllegalStateException("Error reading from " + entry.file + ":" + entry.offset + " | " + handle.getFileSize());
                        }
                        bl = header.expiryTime() < 0L || header.expiryTime() > this.timeService.wallClockTime();
                    }
                    catch (Throwable throwable) {
                        try {
                            handle.close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new CacheException((Throwable)e);
                        }
                    }
                    handle.close();
                    return bl;
                }, (Object)"soft-index-containsKey");
            }
            EntryPosition position = this.index.getPosition(key, this.marshaller.objectToByteBuffer(key));
            return CompletableFutures.booleanStage((position != null ? 1 : 0) != 0);
        }
        catch (Exception e) {
            throw log.cannotLoadKeyFromIndex(key, e);
        }
    }

    public CompletionStage<MarshallableEntry<K, V>> load(int segment, Object key) {
        return this.blockingManager.supplyBlocking(() -> {
            try {
                EntryPosition entry;
                while ((entry = this.temporaryTable.get(segment, key)) != null) {
                    if (entry.offset < 0) {
                        log.tracef("Entry for key=%s found in temporary table on %d:%d but it is a tombstone", key, entry.file, entry.offset);
                        return null;
                    }
                    MarshallableEntry<K, V> marshallableEntry = this.readValueFromFileOffset(key, entry);
                    if (marshallableEntry == null) continue;
                    return marshallableEntry;
                }
                EntryRecord record = this.index.getRecord(key, this.marshaller.objectToByteBuffer(key));
                if (record == null) {
                    return null;
                }
                return this.marshallableEntryFactory.create(this.toBuffer(record.getKey()), this.toBuffer(record.getValue()), this.toBuffer(record.getMetadata()), this.toBuffer(record.getInternalMetadata()), record.getCreated(), record.getLastUsed());
            }
            catch (Exception e) {
                throw log.cannotLoadKeyFromIndex(key, e);
            }
        }, (Object)"soft-index-load");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MarshallableEntry<K, V> readValueFromFileOffset(Object key, EntryPosition entry) throws IOException {
        FileProvider.Handle handle = this.fileProvider.getFile(entry.file);
        if (handle != null) {
            try {
                EntryHeader header = EntryRecord.readEntryHeader(handle, entry.offset);
                if (header == null) {
                    throw new IllegalStateException("Error reading from " + entry.file + ":" + entry.offset + " | " + handle.getFileSize());
                }
                MarshallableEntry marshallableEntry = this.readEntry(handle, header, entry.offset, key, false, (serializedKey, value, meta, internalMeta, created, lastUsed) -> this.marshallableEntryFactory.create(serializedKey, value, meta, internalMeta, created, lastUsed));
                return marshallableEntry;
            }
            finally {
                handle.close();
            }
        }
        return null;
    }

    private MarshallableEntry<K, V> readEntry(FileProvider.Handle handle, EntryHeader header, int offset, Object key, boolean nonNull, EntryCreator<K, V> entryCreator) throws IOException {
        long lastUsed;
        long created;
        ByteBuffer serializedMetadata;
        if (header.expiryTime() > 0L && header.expiryTime() <= this.timeService.wallClockTime()) {
            if (log.isTraceEnabled()) {
                log.tracef("Entry for key=%s found in temporary table on %d:%d but it is expired", key, handle.getFileId(), offset);
            }
            return nonNull ? entryCreator.create(this.readAndCheckKey(handle, header, offset), null, null, null, -1L, -1L) : null;
        }
        ByteBuffer serializedKey = this.readAndCheckKey(handle, header, offset);
        if (header.valueLength() <= 0) {
            if (log.isTraceEnabled()) {
                log.tracef("Entry for key=%s found in temporary table on %d:%d but it is a tombstone in log", key, handle.getFileId(), offset);
            }
            return nonNull ? entryCreator.create(serializedKey, null, null, null, -1L, -1L) : null;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Entry for key=%s found in temporary table on %d:%d and loaded", key, handle.getFileId(), offset);
        }
        ByteBuffer value = this.toBuffer(EntryRecord.readValue(handle, header, offset));
        if (header.metadataLength() > 0) {
            EntryMetadata metadata = EntryRecord.readMetadata(handle, header, offset);
            serializedMetadata = this.toBuffer(metadata.getBytes());
            created = metadata.getCreated();
            lastUsed = metadata.getLastUsed();
        } else {
            serializedMetadata = null;
            created = -1L;
            lastUsed = -1L;
        }
        ByteBuffer internalMetadata = header.internalMetadataLength() > 0 ? this.toBuffer(EntryRecord.readInternalMetadata(handle, header, offset)) : null;
        return entryCreator.create(serializedKey, value, serializedMetadata, internalMetadata, created, lastUsed);
    }

    private ByteBuffer readAndCheckKey(FileProvider.Handle handle, EntryHeader header, int offset) throws IOException {
        ByteBuffer serializedKey = this.toBuffer(EntryRecord.readKey(handle, header, offset));
        if (serializedKey == null) {
            throw new IllegalStateException("Error reading key from " + handle.getFileId() + ":" + offset);
        }
        return serializedKey;
    }

    private ByteBuffer toBuffer(byte[] array) {
        return array == null ? null : this.byteBufferFactory.newByteBuffer(array, 0, array.length);
    }

    private Flowable<Integer> filePublisher() {
        return Flowable.using(this.fileProvider::getFileIterator, it -> Flowable.fromIterable(() -> it), CloseableIterator::close);
    }

    private <R> Flowable<R> handleFilePublisher(Flowable<Integer> filePublisher, boolean fetchValue, boolean fetchMetadata, EntryFunctor<R> functor) {
        return filePublisher.flatMap(f -> {
            int file = f;
            return Flowable.using(() -> {
                log.debugf("Loading entries from file %d", file);
                return Optional.ofNullable(this.fileProvider.getFile(file));
            }, optHandle -> {
                if (!optHandle.isPresent()) {
                    log.debugf("File %d was deleted during iteration", file);
                    return Flowable.empty();
                }
                FileProvider.Handle handle = (FileProvider.Handle)optHandle.get();
                AtomicInteger offset = new AtomicInteger();
                return Flowable.fromIterable(() -> new HandleIterator(offset, handle, fetchMetadata, fetchValue, functor, file));
            }, optHandle -> {
                if (optHandle.isPresent()) {
                    ((FileProvider.Handle)optHandle.get()).close();
                }
            });
        });
    }

    public Publisher<K> publishKeys(IntSet segments, Predicate<? super K> filter) {
        return Flowable.fromPublisher(this.publishEntries(segments, filter, false)).map(MarshallableEntry::getKey);
    }

    public Publisher<MarshallableEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean includeValues) {
        return this.blockingManager.blockingPublisher((Publisher)Flowable.defer(() -> {
            HashSet seenKeys = new HashSet();
            Flowable tableFlowable = this.temporaryTable.publish(segments).doOnNext(entry -> seenKeys.add(entry.getKey()));
            if (filter != null) {
                tableFlowable = tableFlowable.filter(entry -> filter.test((Object)entry.getKey()));
            }
            Flowable entryFlowable = tableFlowable.flatMapMaybe(entry -> {
                EntryPosition position = (EntryPosition)entry.getValue();
                if (position.offset < 0) {
                    return Maybe.empty();
                }
                MarshallableEntry<K, V> marshallableEntry = this.readValueFromFileOffset(entry.getKey(), position);
                if (marshallableEntry == null) {
                    return Maybe.fromCompletionStage(this.load(this.keyPartitioner.getSegment(entry.getKey()), entry.getKey()));
                }
                return Maybe.just(marshallableEntry);
            });
            MarshallableEntry emptyME = this.marshallableEntryFactory.getEmpty();
            Flowable indexFlowable = this.index.publish(segments, includeValues).filter(er -> er.getHeader().valueLength() > 0).map(er -> {
                Object key = this.marshaller.objectFromByteBuffer(er.getKey());
                if (filter != null && !filter.test((K)key) || seenKeys.contains(key)) {
                    return emptyME;
                }
                return this.marshallableEntryFactory.create(key, this.byteBufferFactory.newByteBuffer(er.getValue()), this.byteBufferFactory.newByteBuffer(er.getMetadata()), this.byteBufferFactory.newByteBuffer(er.getInternalMetadata()), er.getCreated(), er.getLastUsed());
            }).filter(me -> me != emptyME);
            return Flowable.concat((Publisher)entryFlowable, (Publisher)indexFlowable);
        }));
    }

    private class HandleIterator<R>
    extends AbstractIterator<R> {
        private final AtomicInteger offset;
        private final FileProvider.Handle handle;
        private final boolean fetchMetadata;
        private final boolean fetchValue;
        private final EntryFunctor<R> functor;
        private final int file;

        public HandleIterator(AtomicInteger offset, FileProvider.Handle handle, boolean fetchMetadata, boolean fetchValue, EntryFunctor<R> functor, int file) {
            this.offset = offset;
            this.handle = handle;
            this.fetchMetadata = fetchMetadata;
            this.fetchValue = fetchValue;
            this.functor = functor;
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected R getNext() {
            R next = null;
            int innerOffset = this.offset.get();
            try {
                while (next == null) {
                    EntryHeader header = EntryRecord.readEntryHeader(this.handle, innerOffset);
                    if (header == null) {
                        return null;
                    }
                    try {
                        byte[] serializedKey = EntryRecord.readKey(this.handle, header, innerOffset);
                        if (serializedKey == null) continue;
                        EntryMetadata meta = null;
                        if (this.fetchMetadata && header.metadataLength() > 0) {
                            meta = EntryRecord.readMetadata(this.handle, header, innerOffset);
                        }
                        byte[] serializedValue = null;
                        int offsetOrNegation = innerOffset;
                        if (header.valueLength() > 0) {
                            if (header.expiryTime() >= 0L && header.expiryTime() <= NonBlockingSoftIndexFileStore.this.timeService.wallClockTime()) {
                                offsetOrNegation = ~innerOffset;
                            } else {
                                serializedValue = this.fetchValue ? EntryRecord.readValue(this.handle, header, innerOffset) : Util.EMPTY_BYTE_ARRAY;
                            }
                        } else {
                            offsetOrNegation = ~innerOffset;
                        }
                        byte[] serializedInternalMetadata = null;
                        if (this.fetchMetadata && header.internalMetadataLength() > 0) {
                            serializedInternalMetadata = EntryRecord.readInternalMetadata(this.handle, header, innerOffset);
                        }
                        next = this.functor.apply(this.file, offsetOrNegation, header.totalLength(), serializedKey, meta, serializedValue, serializedInternalMetadata, header.seqId(), header.expiryTime());
                    }
                    finally {
                        innerOffset = this.offset.addAndGet(header.totalLength());
                    }
                }
                return next;
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }
    }

    private static interface EntryFunctor<R> {
        public R apply(int var1, int var2, int var3, byte[] var4, EntryMetadata var5, byte[] var6, byte[] var7, long var8, long var10) throws Exception;
    }

    public static interface EntryCreator<K, V> {
        public MarshallableEntry<K, V> create(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3, ByteBuffer var4, long var5, long var7) throws IOException;
    }
}

