/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import io.reactivex.rxjava3.internal.fuseable.SimpleQueue;
import io.reactivex.rxjava3.internal.queue.MpscLinkedQueue;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

public class SyncProcessingQueue<T> {
    private static final int BUSY_SPIN = Runtime.getRuntime().availableProcessors() == 1 ? 0 : 10;
    private static final int YIELD_SPIN = 12;
    private static final Object COMPLETED = new Object();
    private static final Object ERROR = new Object();
    private final SimpleQueue<AtomicReference<Object>> queue = new MpscLinkedQueue();
    private final ArrayDeque<AtomicReference<Object>> popped = new ArrayDeque();
    private volatile boolean error = false;
    private volatile Thread blockedConsumer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushAndWait(T element) throws InterruptedException {
        if (this.error) {
            throw new IllegalStateException("Exception in consumer");
        }
        AtomicReference<Object> holder = new AtomicReference<Object>();
        holder.lazySet(element);
        this.queue.offer(holder);
        Thread blockedConsumer = this.blockedConsumer;
        if (blockedConsumer != null) {
            LockSupport.unpark(blockedConsumer);
        }
        try {
            Object e;
            int i;
            for (i = 0; i < BUSY_SPIN; ++i) {
                e = holder.get();
                if (e == null) {
                    return;
                }
                if (e != ERROR) continue;
                throw new IllegalStateException("Exception in consumer");
            }
            for (i = 0; i < 12; ++i) {
                e = holder.get();
                if (e == null) {
                    return;
                }
                if (e == ERROR) {
                    throw new IllegalStateException("Exception in consumer");
                }
                Thread.yield();
            }
            AtomicReference<Object> atomicReference = holder;
            synchronized (atomicReference) {
                while ((e = holder.get()) != null) {
                    if (e == ERROR) {
                        throw new IllegalStateException("Exception in consumer");
                    }
                    holder.wait();
                }
            }
        }
        finally {
            holder.lazySet(COMPLETED);
        }
    }

    public T pop() {
        return this.pop(false);
    }

    private T pop(boolean withError) {
        AtomicReference holder;
        block8: {
            assert (this.error == withError);
            holder = null;
            try {
                holder = (AtomicReference)this.queue.poll();
            }
            catch (Throwable throwable) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
        if (holder == null) {
            return null;
        }
        Object e = holder.get();
        assert (e != null && e != COMPLETED && e != ERROR);
        if (withError) {
            this.handleItem(holder, true);
        } else {
            boolean alwaysTrue = this.popped.offer(holder);
            assert (alwaysTrue);
        }
        return (T)e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleItem(AtomicReference<Object> holder, boolean withError) {
        int i;
        holder.lazySet(withError ? ERROR : null);
        for (i = 0; i < BUSY_SPIN; ++i) {
            if (holder.get() != COMPLETED) continue;
            return;
        }
        for (i = 0; i < 12; ++i) {
            if (holder.get() == COMPLETED) {
                return;
            }
            Thread.yield();
        }
        if (holder.get() == COMPLETED) {
            return;
        }
        AtomicReference<Object> atomicReference = holder;
        synchronized (atomicReference) {
            holder.notify();
        }
    }

    public void notifyNoWait() {
        AtomicReference<Object> holder;
        assert (!this.error);
        while ((holder = this.popped.poll()) != null) {
            this.handleItem(holder, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyAndWait() {
        AtomicReference<Object> holder;
        assert (!this.error);
        while ((holder = this.popped.poll()) != null) {
            this.handleItem(holder, false);
        }
        Thread currentThread = Thread.currentThread();
        while (this.queue.isEmpty()) {
            this.blockedConsumer = currentThread;
            try {
                if (!this.queue.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
                LockSupport.park();
                if (!currentThread.isInterrupted()) continue;
                boolean bl = false;
                return bl;
            }
            finally {
                this.blockedConsumer = null;
            }
        }
        return true;
    }

    public void notifyError() {
        AtomicReference<Object> holder;
        this.error = true;
        while ((holder = this.popped.poll()) != null) {
            this.handleItem(holder, true);
        }
        while (this.pop(true) != null) {
        }
    }
}

