package org.infinispan.persistence.sifs;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import java.io.IOException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.InterruptedException;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import org.infinispan.persistence.spi.PersistenceException;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-10-19T16:59:32-0400")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String maxNodeSizeLimitedToShort = "ISPN029001: Max size of index node (%d) is limited to 32767 bytes.";
    protected String maxNodeSizeLimitedToShort$str() {
        return maxNodeSizeLimitedToShort;
    }
    @Override
    public final CacheConfigurationException maxNodeSizeLimitedToShort(final int maxNodeSize) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), maxNodeSizeLimitedToShort$str(), maxNodeSize));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String minNodeSizeMustBeLessOrEqualToMax = "ISPN029002: Min size of index node (%d) must be less or equal to max size (%d).";
    protected String minNodeSizeMustBeLessOrEqualToMax$str() {
        return minNodeSizeMustBeLessOrEqualToMax;
    }
    @Override
    public final CacheConfigurationException minNodeSizeMustBeLessOrEqualToMax(final int minNodeSize, final int maxNodeSize) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), minNodeSizeMustBeLessOrEqualToMax$str(), minNodeSize, maxNodeSize));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String sizeCalculationInterrupted = "ISPN029003: Calculation of size has been interrupted.";
    protected String sizeCalculationInterrupted$str() {
        return sizeCalculationInterrupted;
    }
    @Override
    public final PersistenceException sizeCalculationInterrupted(final InterruptedException e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), sizeCalculationInterrupted$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void cannotTruncateIndex(final IOException e) {
        super.log.logf(FQCN, WARN, e, cannotTruncateIndex$str());
    }
    private static final String cannotTruncateIndex = "ISPN029006: Cannot truncate index";
    protected String cannotTruncateIndex$str() {
        return cannotTruncateIndex;
    }
    @Override
    public final void errorInIndexUpdater(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, errorInIndexUpdater$str());
    }
    private static final String errorInIndexUpdater = "ISPN029007: Unexpected error in index updater thread.";
    protected String errorInIndexUpdater$str() {
        return errorInIndexUpdater;
    }
    @Override
    public final void failedToCloseIndex(final IOException e) {
        super.log.logf(FQCN, ERROR, e, failedToCloseIndex$str());
    }
    private static final String failedToCloseIndex = "ISPN029008: Failed to close the index file.";
    protected String failedToCloseIndex$str() {
        return failedToCloseIndex;
    }
    @Override
    public final void compactorFailed(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, compactorFailed$str());
    }
    private static final String compactorFailed = "ISPN029009: Unexpected error in data compactor.";
    protected String compactorFailed$str() {
        return compactorFailed;
    }
    @Override
    public final void cannotCloseDeleteFile(final int fileId, final IOException e) {
        super.log.logf(FQCN, ERROR, e, cannotCloseDeleteFile$str(), fileId);
    }
    private static final String cannotCloseDeleteFile = "ISPN290010: Cannot close/delete data file %d.";
    protected String cannotCloseDeleteFile$str() {
        return cannotCloseDeleteFile;
    }
    @Override
    public final void cannotCloseFile(final IOException e) {
        super.log.logf(FQCN, ERROR, e, cannotCloseFile$str());
    }
    private static final String cannotCloseFile = "ISPN029011: Cannot close data file.";
    protected String cannotCloseFile$str() {
        return cannotCloseFile;
    }
    private static final String invalidCompactionThreshold = "ISPN029012: Compaction threshold (%f) should be between 0 (exclusively) and 1 (inclusively).";
    protected String invalidCompactionThreshold$str() {
        return invalidCompactionThreshold;
    }
    @Override
    public final CacheConfigurationException invalidCompactionThreshold(final double value) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidCompactionThreshold$str(), value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotOpenIndex = "ISPN029013: Cannot open index on %s";
    protected String cannotOpenIndex$str() {
        return cannotOpenIndex;
    }
    @Override
    public final PersistenceException cannotOpenIndex(final String location, final IOException e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), cannotOpenIndex$str(), location), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String interruptedWhileStopping = "ISPN029014: Interrupted while stopping the store";
    protected String interruptedWhileStopping$str() {
        return interruptedWhileStopping;
    }
    @Override
    public final PersistenceException interruptedWhileStopping(final InterruptedException e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), interruptedWhileStopping$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String interruptedWhileClearing = "ISPN029015: Interrupted while pausing the index for clear.";
    protected String interruptedWhileClearing$str() {
        return interruptedWhileClearing;
    }
    @Override
    public final PersistenceException interruptedWhileClearing(final InterruptedException e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), interruptedWhileClearing$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotClearIndex = "ISPN029016: Cannot clear/reopen index.";
    protected String cannotClearIndex$str() {
        return cannotClearIndex;
    }
    @Override
    public final PersistenceException cannotClearIndex(final IOException e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), cannotClearIndex$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotClearData = "ISPN029017: Cannot clear data directory.";
    protected String cannotClearData$str() {
        return cannotClearData;
    }
    @Override
    public final PersistenceException cannotClearData(final IOException e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), cannotClearData$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyIsTooLong = "ISPN029018: The serialized form of key %s is too long (%d); with maxNodeSize=%d bytes you can use only keys serialized to at most %d bytes.";
    protected String keyIsTooLong$str() {
        return keyIsTooLong;
    }
    @Override
    public final PersistenceException keyIsTooLong(final Object key, final int keyLength, final int maxNodeSize, final int maxKeyLength) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), keyIsTooLong$str(), key, keyLength, maxNodeSize, maxKeyLength));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotLoadKeyFromIndex = "ISPN029019: Cannot load key %s from index.";
    protected String cannotLoadKeyFromIndex$str() {
        return cannotLoadKeyFromIndex;
    }
    @Override
    public final PersistenceException cannotLoadKeyFromIndex(final Object key, final Exception e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), cannotLoadKeyFromIndex$str(), key), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String indexLooksCorrupt = "ISPN029020: Index looks corrupt.";
    protected String indexLooksCorrupt$str() {
        return indexLooksCorrupt;
    }
    @Override
    public final PersistenceException indexLooksCorrupt(final Exception e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), indexLooksCorrupt$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
