/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.persistence.sifs.Log;
import org.infinispan.persistence.spi.PersistenceException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String maxNodeSizeLimitedToShort = "ISPN029001: Max size of index node (%d) is limited to 32767 bytes.";
    private static final String minNodeSizeMustBeLessOrEqualToMax = "ISPN029002: Min size of index node (%d) must be less or equal to max size (%d).";
    private static final String sizeCalculationInterrupted = "ISPN029003: Calculation of size has been interrupted.";
    private static final String cannotTruncateIndex = "ISPN029006: Cannot truncate index";
    private static final String errorInIndexUpdater = "ISPN029007: Unexpected error in index updater thread.";
    private static final String failedToCloseIndex = "ISPN029008: Failed to close the index file.";
    private static final String compactorFailed = "ISPN029009: Unexpected error in data compactor.";
    private static final String cannotCloseDeleteFile = "ISPN290010: Cannot close/delete data file %d.";
    private static final String cannotCloseFile = "ISPN029011: Cannot close data file.";
    private static final String invalidCompactionThreshold = "ISPN029012: Compaction threshold (%f) should be between 0 (exclusively) and 1 (inclusively).";
    private static final String cannotOpenIndex = "ISPN029013: Cannot open index on %s";
    private static final String interruptedWhileStopping = "ISPN029014: Interrupted while stopping the store";
    private static final String interruptedWhileClearing = "ISPN029015: Interrupted while pausing the index for clear.";
    private static final String cannotClearIndex = "ISPN029016: Cannot clear/reopen index.";
    private static final String cannotClearData = "ISPN029017: Cannot clear data directory.";
    private static final String keyIsTooLong = "ISPN029018: The serialized form of key %s is too long (%d); with maxNodeSize=%d bytes you can use only keys serialized to at most %d bytes.";
    private static final String cannotLoadKeyFromIndex = "ISPN029019: Cannot load key %s from index.";
    private static final String indexLooksCorrupt = "ISPN029020: Index looks corrupt.";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String maxNodeSizeLimitedToShort$str() {
        return maxNodeSizeLimitedToShort;
    }

    @Override
    public final CacheConfigurationException maxNodeSizeLimitedToShort(int maxNodeSize) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.maxNodeSizeLimitedToShort$str(), maxNodeSize));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String minNodeSizeMustBeLessOrEqualToMax$str() {
        return minNodeSizeMustBeLessOrEqualToMax;
    }

    @Override
    public final CacheConfigurationException minNodeSizeMustBeLessOrEqualToMax(int minNodeSize, int maxNodeSize) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.minNodeSizeMustBeLessOrEqualToMax$str(), minNodeSize, maxNodeSize));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sizeCalculationInterrupted$str() {
        return sizeCalculationInterrupted;
    }

    @Override
    public final PersistenceException sizeCalculationInterrupted(InterruptedException e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.sizeCalculationInterrupted$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void cannotTruncateIndex(IOException e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.cannotTruncateIndex$str(), new Object[0]);
    }

    protected String cannotTruncateIndex$str() {
        return cannotTruncateIndex;
    }

    @Override
    public final void errorInIndexUpdater(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.errorInIndexUpdater$str(), new Object[0]);
    }

    protected String errorInIndexUpdater$str() {
        return errorInIndexUpdater;
    }

    @Override
    public final void failedToCloseIndex(IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToCloseIndex$str(), new Object[0]);
    }

    protected String failedToCloseIndex$str() {
        return failedToCloseIndex;
    }

    @Override
    public final void compactorFailed(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.compactorFailed$str(), new Object[0]);
    }

    protected String compactorFailed$str() {
        return compactorFailed;
    }

    @Override
    public final void cannotCloseDeleteFile(int fileId, IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.cannotCloseDeleteFile$str(), (Object)fileId);
    }

    protected String cannotCloseDeleteFile$str() {
        return cannotCloseDeleteFile;
    }

    @Override
    public final void cannotCloseFile(IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.cannotCloseFile$str(), new Object[0]);
    }

    protected String cannotCloseFile$str() {
        return cannotCloseFile;
    }

    protected String invalidCompactionThreshold$str() {
        return invalidCompactionThreshold;
    }

    @Override
    public final CacheConfigurationException invalidCompactionThreshold(double value) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidCompactionThreshold$str(), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotOpenIndex$str() {
        return cannotOpenIndex;
    }

    @Override
    public final PersistenceException cannotOpenIndex(String location, IOException e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.cannotOpenIndex$str(), location), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String interruptedWhileStopping$str() {
        return interruptedWhileStopping;
    }

    @Override
    public final PersistenceException interruptedWhileStopping(InterruptedException e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.interruptedWhileStopping$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String interruptedWhileClearing$str() {
        return interruptedWhileClearing;
    }

    @Override
    public final PersistenceException interruptedWhileClearing(InterruptedException e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.interruptedWhileClearing$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotClearIndex$str() {
        return cannotClearIndex;
    }

    @Override
    public final PersistenceException cannotClearIndex(IOException e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.cannotClearIndex$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotClearData$str() {
        return cannotClearData;
    }

    @Override
    public final PersistenceException cannotClearData(IOException e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.cannotClearData$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String keyIsTooLong$str() {
        return keyIsTooLong;
    }

    @Override
    public final PersistenceException keyIsTooLong(Object key, int keyLength, int maxNodeSize, int maxKeyLength) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.keyIsTooLong$str(), key, keyLength, maxNodeSize, maxKeyLength));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotLoadKeyFromIndex$str() {
        return cannotLoadKeyFromIndex;
    }

    @Override
    public final PersistenceException cannotLoadKeyFromIndex(Object key, Exception e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.cannotLoadKeyFromIndex$str(), key), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String indexLooksCorrupt$str() {
        return indexLooksCorrupt;
    }

    @Override
    public final PersistenceException indexLooksCorrupt(Exception e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.indexLooksCorrupt$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

