/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs.configuration;

import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.persistence.sifs.configuration.Element;

public class DataConfiguration
implements ConfigurationInfo {
    public static final AttributeDefinition<String> DATA_LOCATION = AttributeDefinition.builder((String)"dataLocation", null, String.class).immutable().autoPersist(false).xmlName("path").build();
    public static final AttributeDefinition<Integer> MAX_FILE_SIZE = AttributeDefinition.builder((String)"maxFileSize", (Object)0x1000000).immutable().autoPersist(false).build();
    public static final AttributeDefinition<Boolean> SYNC_WRITES = AttributeDefinition.builder((String)"syncWrites", (Object)false).immutable().autoPersist(false).build();
    private final AttributeSet attributes;
    static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.DATA.getLocalName());

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(DataConfiguration.class, new AttributeDefinition[]{DATA_LOCATION, MAX_FILE_SIZE, SYNC_WRITES});
    }

    DataConfiguration(AttributeSet attributes) {
        this.attributes = attributes;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public int maxFileSize() {
        return (Integer)this.attributes.attribute(MAX_FILE_SIZE).get();
    }

    public boolean syncWrites() {
        return (Boolean)this.attributes.attribute(SYNC_WRITES).get();
    }

    public String dataLocation() {
        return (String)this.attributes.attribute(DATA_LOCATION).get();
    }

    public void setDataLocation(String newLocation) {
        this.attributes.attribute(DATA_LOCATION).set((Object)newLocation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataConfiguration that = (DataConfiguration)o;
        return this.attributes.equals((Object)that.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        return "DataConfiguration{attributes=" + this.attributes + '}';
    }
}

