/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.nio.ByteBuffer;

public class EntryHeader {
    static final int MAGIC = -1106139620;
    static final boolean useMagic = false;
    static final int HEADER_SIZE = 24;
    private final int keyLength;
    private final int valueLength;
    private final int metadataLength;
    private final long seqId;
    private final long expiration;

    public EntryHeader(ByteBuffer buffer) {
        this.keyLength = buffer.getShort();
        this.metadataLength = buffer.getShort();
        this.valueLength = buffer.getInt();
        this.seqId = buffer.getLong();
        this.expiration = buffer.getLong();
    }

    public int keyLength() {
        return this.keyLength;
    }

    public int metadataLength() {
        return this.metadataLength;
    }

    public int valueLength() {
        return this.valueLength;
    }

    public long seqId() {
        return this.seqId;
    }

    public long expiryTime() {
        return this.expiration;
    }

    public String toString() {
        return String.format("[keyLength=%d, valueLength=%d, metadataLength=%d, seqId=%d, expiration=%d]", this.keyLength, this.valueLength, this.metadataLength, this.seqId, this.expiration);
    }

    public int totalLength() {
        return this.keyLength + this.metadataLength + this.valueLength + 24;
    }
}

